/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.BindingManager;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EFeatureAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EObjectAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtTextAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledWidget;
import org.eclipse.stardust.modeling.core.editors.ui.validation.PageValidationManager;
import org.eclipse.stardust.modeling.core.utils.ExtensibleElementAdapter;
import org.eclipse.stardust.modeling.core.utils.ExtensibleElementValueAdapter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WidgetBindingManager {
    private final BindingManager mBndMgr = new BindingManager();
    private final PageValidationManager vBndMgr;

    public WidgetBindingManager(IPreferencePage page) {
        this.vBndMgr = new PageValidationManager(page);
    }

    public BindingManager getModelBindingManager() {
        return this.mBndMgr;
    }

    public PageValidationManager getValidationBindingManager() {
        return this.vBndMgr;
    }

    public void dispose() {
        this.vBndMgr.dispose();
        this.mBndMgr.dispose();
    }

    public void unbindModel(EObject model) {
        this.vBndMgr.unbind(model);
        this.mBndMgr.unbind((Object)model);
    }

    public void bind(LabeledWidget widget, IWidgetAdapter widgetAdapter, IExtensibleElement model, String attribute) {
        this.mBndMgr.bind(WidgetBindingManager.createModelAdapter(model, attribute, false), widgetAdapter);
        this.vBndMgr.bind((EObject)model, (Object)attribute, widget.getLabel());
    }

    public void bind(LabeledWidget widget, IWidgetAdapter widgetAdapter, IExtensibleElement model, String attribute, ExtensibleElementValueAdapter modelValueAdapter) {
        this.mBndMgr.bind(WidgetBindingManager.createModelAdapter(model, attribute, modelValueAdapter), widgetAdapter);
        this.vBndMgr.bind((EObject)model, (Object)attribute, widget.getLabel());
    }

    public void bind(LabeledViewer text, EObject model, EStructuralFeature feature) {
        this.mBndMgr.bind(model, feature, text.getViewer());
        this.vBndMgr.bind(model, (Object)feature, text.getLabel());
    }

    public void bind(LabeledViewer text, EObject model, EStructuralFeature feature, EFeatureAdapter featureAdapter) {
        this.mBndMgr.bind(BindingManager.createModelAdapter((EObject)model, (EStructuralFeature)feature, (EFeatureAdapter)featureAdapter), BindingManager.createWidgetAdapter((StructuredViewer)text.getViewer()));
        this.vBndMgr.bind(model, (Object)feature, text.getLabel());
    }

    public void bind(LabeledText text, EObject model, EStructuralFeature feature) {
        this.mBndMgr.bind(model, feature, text.getText());
        this.vBndMgr.bind(model, (Object)feature, text.getLabel());
    }

    public void bind(LabeledText text, EObject model, EStructuralFeature feature, EFeatureAdapter featureAdapter) {
        this.mBndMgr.bind(BindingManager.createModelAdapter((EObject)model, (EStructuralFeature)feature, (EFeatureAdapter)featureAdapter), (IWidgetAdapter)new SwtTextAdapter(text.getText()));
        this.vBndMgr.bind(model, (Object)feature, text.getLabel());
    }

    public void bind(LabeledText text, EObjectAdapter aModel) {
        this.mBndMgr.bind((IModelAdapter)aModel, (IWidgetAdapter)new SwtTextAdapter(text.getText()));
        this.vBndMgr.bind(aModel.getEModel(), aModel.getFeature(), text.getLabel());
    }

    public void bind(LabeledText text, IExtensibleElement model, String attribute) {
        this.mBndMgr.bind(WidgetBindingManager.createModelAdapter(model, attribute, false), BindingManager.createWidgetAdapter((Text)text.getText()));
        this.vBndMgr.bind((EObject)model, (Object)attribute, text.getLabel());
    }

    public void bind(LabeledCombo combo, IExtensibleElement model, String attribute) {
        this.mBndMgr.bind(WidgetBindingManager.createModelAdapter(model, attribute, false), BindingManager.createWidgetAdapter((Combo)combo.getCombo()));
        this.vBndMgr.bind((EObject)model, (Object)attribute, combo.getLabel());
    }

    public void bind(LabeledViewer text, IExtensibleElement model, String attribute, EObject scope, EStructuralFeature feature) {
        this.mBndMgr.bind(WidgetBindingManager.createModelAdapter(model, attribute, scope, feature), BindingManager.createWidgetAdapter((StructuredViewer)text.getViewer()));
        this.vBndMgr.bind((EObject)model, (Object)attribute, text.getLabel());
    }

    public void bind(LabeledViewer text, IExtensibleElement model, String attribute, List scope) {
        this.mBndMgr.bind(WidgetBindingManager.createModelAdapter(model, attribute, scope), BindingManager.createWidgetAdapter((StructuredViewer)text.getViewer()));
        this.vBndMgr.bind((EObject)model, (Object)attribute, text.getLabel());
    }

    public void bind(LabeledViewer text, IExtensibleElement model, String attribute, ExtensibleElementValueAdapter modelValueAdapter) {
        this.mBndMgr.bind(WidgetBindingManager.createModelAdapter(model, attribute, modelValueAdapter), BindingManager.createWidgetAdapter((StructuredViewer)text.getViewer()));
        this.vBndMgr.bind((EObject)model, (Object)attribute, text.getLabel());
    }

    public void unbind(LabeledText text, IExtensibleElement model, Object feature) {
        this.mBndMgr.unbind((EObject)model, (Widget)text.getText());
        this.vBndMgr.unbind((EObject)model, feature, (Widget)text.getLabel());
    }

    public void unbind(LabeledViewer text, IExtensibleElement model, Object feature) {
        this.mBndMgr.unbind((EObject)model, (Widget)text.getViewer().getControl());
        this.vBndMgr.unbind((EObject)model, feature, (Widget)text.getLabel());
    }

    public void bind(Button localBinding, IExtensibleElement model, String attribute) {
        this.mBndMgr.bind(WidgetBindingManager.createModelAdapter(model, attribute, true), BindingManager.createWidgetAdapter((Button)localBinding));
    }

    public static IModelAdapter createModelAdapter(IExtensibleElement ext, String att, boolean isBoolean) {
        return new ExtensibleElementAdapter((EObject)ext, att, isBoolean);
    }

    public static IModelAdapter createModelAdapter(IExtensibleElement ext, String att, EObject scope, EStructuralFeature feature) {
        return new ExtensibleElementAdapter((EObject)ext, att, scope, feature);
    }

    public static IModelAdapter createModelAdapter(IExtensibleElement ext, String att, List scope) {
        return new ExtensibleElementAdapter((EObject)ext, att, scope);
    }

    public static IModelAdapter createModelAdapter(IExtensibleElement ext, String att, ExtensibleElementValueAdapter modelValueAdapter) {
        return new ExtensibleElementAdapter((EObject)ext, att, false, modelValueAdapter);
    }

    public void unbind(IModelElement model) {
        this.mBndMgr.unbind((Object)model);
        this.vBndMgr.unbind(model);
    }
}

