/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.repository;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.views.repository.CreateVersionAction;
import org.eclipse.stardust.modeling.core.views.repository.ProjectContentProvider;
import org.eclipse.stardust.modeling.core.views.repository.ResourceInfo;
import org.eclipse.stardust.modeling.core.views.repository.VersionRepository;
import org.eclipse.ui.IWorkbenchPart;

public class CopyVersionAction
extends CreateVersionAction {
    private String newId;
    private String originalId;

    public CopyVersionAction(IWorkbenchPart part) {
        super(part, -1);
        this.setText(Diagram_Messages.LB_ACTION_CopyVersion);
    }

    @Override
    protected boolean calculateEnabled() {
        this.originalId = null;
        return super.calculateEnabled();
    }

    @Override
    protected boolean calculateEnabled(ResourceInfo info, IFile file) {
        if (this.originalId == null) {
            this.originalId = info.getId();
        } else if (!this.originalId.equals(info.getId())) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean supportsMultiSelection() {
        return true;
    }

    @Override
    public void run() {
        this.newId = null;
        super.run();
    }

    @Override
    protected boolean updateModel(IFile file, ModelType model) {
        if (this.newId == null) {
            this.newId = this.getNewIdProposal(model.getId());
            InputDialog dialog = new InputDialog(this.getShell(), Diagram_Messages.LB_ACTION_CopyVersion, Diagram_Messages.MSG_EnterNewID, this.newId, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.length() == 0) {
                        return Diagram_Messages.MSG_NoId;
                    }
                    if (CopyVersionAction.this.existsId(newText)) {
                        return MessageFormat.format(Diagram_Messages.MSG_ANOTHER_MODEL_HIERARCHY_WITH_ID_ALREADY_EXISTS, newText);
                    }
                    return null;
                }
            });
            if (dialog.open() == 0) {
                this.newId = dialog.getValue();
            } else {
                return false;
            }
        }
        model.setId(this.newId);
        this.basicFileName = this.newId;
        return true;
    }

    private String getNewIdProposal(String id) {
        int ix = 0;
        while (true) {
            String proposal;
            String string = proposal = ix == 0 ? String.valueOf(id) + "_copy" : String.valueOf(id) + ix + "_copy";
            if (!this.existsId(proposal)) {
                return proposal;
            }
            ++ix;
        }
    }

    private boolean existsId(String proposal) {
        VersionRepository repository = (VersionRepository)this.getWorkbenchPart();
        ProjectContentProvider provider = repository.getContentProvider();
        ResourceInfo root = provider.getRoot();
        return root != null && root.findChild(proposal) != null;
    }
}

