/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.repository;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.views.repository.ProjectContentProvider;
import org.eclipse.stardust.modeling.core.views.repository.ResourceInfo;
import org.eclipse.stardust.modeling.core.views.repository.VersionRepository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class RepositoryAction
extends SelectionAction {
    public RepositoryAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    protected boolean calculateEnabled() {
        IFile file;
        ResourceInfo info;
        VersionRepository repository = (VersionRepository)this.getWorkbenchPart();
        ProjectContentProvider provider = repository.getContentProvider();
        List selection = this.getSelectedObjects();
        if (this.supportsMultiSelection()) {
            boolean result = false;
            int i = 0;
            while (i < selection.size()) {
                IFile file2;
                ResourceInfo info2;
                Object o = selection.get(i);
                if (o instanceof IFile && (info2 = provider.findResource((IResource)(file2 = (IFile)o))) != null) {
                    if (this.calculateEnabled(info2, file2)) {
                        result = true;
                    } else {
                        return false;
                    }
                }
                ++i;
            }
            return result;
        }
        if (selection.size() == 1 && selection.get(0) instanceof IFile && (info = provider.findResource((IResource)(file = (IFile)selection.get(0)))) != null) {
            return this.calculateEnabled(info, file);
        }
        return false;
    }

    protected ResourceInfo findResource(IFile file) {
        VersionRepository repository = (VersionRepository)this.getWorkbenchPart();
        ProjectContentProvider provider = repository.getContentProvider();
        return provider.findResource((IResource)file);
    }

    protected abstract boolean calculateEnabled(ResourceInfo var1, IFile var2);

    protected abstract boolean supportsMultiSelection();

    protected abstract boolean run(IFile var1);

    public void run() {
        List objects = this.getSelectedObjects();
        int i = 0;
        while (i < objects.size()) {
            Object o = objects.get(i);
            if (o instanceof IFile && !this.run((IFile)o)) break;
            ++i;
        }
        this.update();
    }

    protected void openEditor(final IFile file) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    protected Shell getShell() {
        return this.getWorkbenchPart().getSite().getShell();
    }

    protected ModelType create(IFile file) throws CoreException {
        ModelType model = null;
        WorkflowModelManager modelManager = new WorkflowModelManager();
        if (file.exists()) {
            try {
                modelManager.load(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
            }
            catch (Exception e) {
                throw new PartInitException(Diagram_Messages.EX_FailedLoadingModel, (Throwable)e);
            }
            model = modelManager.getModel();
            if (model == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.EX_ErrorLoadingNetwork, null));
            }
        }
        return model;
    }
}

