/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.repository;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.modeling.core.views.repository.CopyVersionAction;
import org.eclipse.stardust.modeling.core.views.repository.CreateVersionAction;
import org.eclipse.stardust.modeling.core.views.repository.DeleteVersionAction;
import org.eclipse.stardust.modeling.core.views.repository.OpenVersionAction;
import org.eclipse.stardust.modeling.core.views.repository.RepositoryAction;
import org.eclipse.stardust.modeling.core.views.repository.VersionRepository;
import org.eclipse.ui.IWorkbenchPart;

public class RepositoryActionSet
implements ISelectionChangedListener {
    private RepositoryAction[] actions;

    public RepositoryActionSet(VersionRepository repository, TreeViewer viewer) {
        this.actions = new RepositoryAction[]{new OpenVersionAction((IWorkbenchPart)repository), new DeleteVersionAction((IWorkbenchPart)repository), new CreateVersionAction((IWorkbenchPart)repository, 0), new CreateVersionAction((IWorkbenchPart)repository, 1), new CopyVersionAction((IWorkbenchPart)repository)};
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        int i = 0;
        while (i < this.actions.length) {
            RepositoryAction action = this.actions[i];
            action.update();
            ++i;
        }
    }

    public void addActions(IMenuManager manager) {
        int i = 0;
        while (i < this.actions.length) {
            RepositoryAction action = this.actions[i];
            if (action.isEnabled()) {
                manager.add((IAction)action);
            }
            ++i;
        }
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        int i = 0;
        while (i < this.actions.length) {
            RepositoryAction action = this.actions[i];
            action.setSelectionProvider(provider);
            ++i;
        }
    }

    public void open(OpenEvent event) {
        if (this.actions[0].isEnabled()) {
            this.actions[0].run();
        }
    }
}

