/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IMemento;

public class ResourceInfo {
    private String file;
    private String id;
    private String name;
    private String version;
    private String label;
    private boolean pseudoNode;
    private ArrayList children = new ArrayList();
    private ResourceInfo parent;
    private int[] versionNumbers;
    private static final String MEMENTO_FILE_TYPE = "org.eclipse.stardust.modeling.core.versionInfo";
    private static final String FILE_KEY = "file";
    private static final String ID_KEY = "id";
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "version";
    private static final String LABEL_KEY = "label";
    private static final String PSEUDO_KEY = "pseudoNode";
    private String basicFileName;

    private ResourceInfo(String id, String name) {
        this.id = id;
        this.label = String.valueOf(name) + " ( " + id + " )";
        this.pseudoNode = true;
    }

    private ResourceInfo(String id, int[] version) {
        this.id = id;
        this.versionNumbers = version;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < version.length) {
            sb.append(version[i]).append('.');
            ++i;
        }
        sb.append('x');
        this.label = sb.toString();
        this.pseudoNode = true;
    }

    public ResourceInfo(IFile file, String id, String name, String version, int[] versionNumbers) {
        if (file != null) {
            this.file = file.getFullPath().toString();
        }
        this.id = id;
        this.name = name;
        this.version = version;
        this.setLabel(versionNumbers);
    }

    public ResourceInfo(IMemento memento) {
        this.loadState(memento);
    }

    public ResourceInfo(String id, String name, String fileName) {
        this(id, name);
        this.basicFileName = fileName;
    }

    private void setLabel(int[] vs) {
        if (vs == null || vs.length == 0) {
            this.versionNumbers = new int[]{1};
            this.version = "1";
        } else {
            this.versionNumbers = new int[vs.length];
            System.arraycopy(vs, 0, this.versionNumbers, 0, vs.length);
        }
        StringBuffer sb = new StringBuffer();
        if (this.file == null) {
            sb.append('<');
        }
        if (this.version != null) {
            sb.append(this.version);
        }
        if (this.file == null) {
            sb.append('>');
        }
        this.label = sb.toString();
    }

    public String toString() {
        return this.label;
    }

    public void add(ResourceInfo resourceInfo) {
        ResourceInfo parent = resourceInfo.getParent();
        if (parent != null) {
            parent.remove(resourceInfo);
        }
        this.children.add(resourceInfo);
        resourceInfo.setParent(this);
    }

    private void setParent(ResourceInfo parent) {
        this.parent = parent;
    }

    public void remove(ResourceInfo resourceInfo) {
        this.children.remove(resourceInfo);
        resourceInfo.setParent(null);
    }

    public ResourceInfo[] getChildren() {
        return this.children.toArray(new ResourceInfo[this.children.size()]);
    }

    public ResourceInfo getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public int[] getVersionNumbers() {
        return this.versionNumbers;
    }

    public void set(ResourceInfo ref) {
        this.file = ref.file;
        this.id = ref.id;
        this.name = ref.name;
        this.version = ref.version;
        this.label = ref.label;
        this.versionNumbers = ref.versionNumbers;
    }

    public String getName() {
        return this.name;
    }

    public ResourceInfo findChild(int[] version) {
        int i = 0;
        while (i < this.children.size()) {
            ResourceInfo info = (ResourceInfo)this.children.get(i);
            if (Arrays.equals(info.getVersionNumbers(), version)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public ResourceInfo findChild(String id) {
        int i = 0;
        while (i < this.children.size()) {
            ResourceInfo info = (ResourceInfo)this.children.get(i);
            if (info.getId().equals(id)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceInfo)) {
            return false;
        }
        ResourceInfo resourceInfo = (ResourceInfo)o;
        if (this.isVirtual() != resourceInfo.isVirtual()) {
            return false;
        }
        if (this.isVirtual()) {
            if (this.id == null && resourceInfo.id != null || this.id != null && !this.id.equals(resourceInfo.id)) {
                return false;
            }
            return Arrays.equals(this.versionNumbers, resourceInfo.versionNumbers);
        }
        return !(this.file != null ? !this.file.equals(resourceInfo.file) : resourceInfo.file != null);
    }

    public int hashCode() {
        return this.file != null ? this.file.hashCode() : 0;
    }

    public boolean isVirtual() {
        return this.file == null;
    }

    public boolean isPseudoNode() {
        return this.pseudoNode;
    }

    public void setVirtual() {
        this.file = null;
        this.name = null;
        this.version = ResourceInfo.toString(this.versionNumbers);
        this.setLabel(this.versionNumbers);
    }

    public void saveState(IMemento memento) {
        this.save(memento, FILE_KEY, this.file);
        this.save(memento, ID_KEY, this.id);
        this.save(memento, NAME_KEY, this.name);
        this.save(memento, VERSION_KEY, this.version);
        this.save(memento, LABEL_KEY, this.label);
        this.save(memento, PSEUDO_KEY, this.pseudoNode ? "TRUE" : "FALSE");
        int i = 0;
        while (i < this.children.size()) {
            this.save(memento, (ResourceInfo)this.children.get(i));
            ++i;
        }
    }

    private void save(IMemento memento, ResourceInfo info) {
        IMemento child = memento.createChild(MEMENTO_FILE_TYPE);
        info.saveState(child);
    }

    private void save(IMemento memento, String name, String value) {
        if (value != null && value.length() > 0) {
            memento.putString(name, value);
        }
    }

    public void loadState(IMemento memento) {
        if (memento != null) {
            this.file = memento.getString(FILE_KEY);
            this.id = memento.getString(ID_KEY);
            this.name = memento.getString(NAME_KEY);
            this.version = memento.getString(VERSION_KEY);
            this.label = memento.getString(LABEL_KEY);
            this.pseudoNode = "TRUE".equals(memento.getString(PSEUDO_KEY));
            this.versionNumbers = ResourceInfo.getVersionNumbers(this.version);
            IMemento[] childrens = memento.getChildren(MEMENTO_FILE_TYPE);
            if (childrens != null) {
                int i = 0;
                while (i < childrens.length) {
                    this.add(new ResourceInfo(childrens[i]));
                    ++i;
                }
            }
        }
    }

    public static int[] getVersionNumbers(String version) {
        if (version == null) {
            return new int[0];
        }
        StringTokenizer st = new StringTokenizer(version.trim(), ".");
        int[] numbers = new int[st.countTokens()];
        int c = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() == 0) {
                numbers[c++] = 0;
                continue;
            }
            try {
                numbers[c++] = Integer.parseInt(token);
            }
            catch (Exception exception) {
                numbers[c++] = 0;
            }
        }
        return numbers;
    }

    public String getFile() {
        return this.file;
    }

    public String getBasicFileName() {
        if (this.basicFileName == null && this.file != null) {
            this.basicFileName = this.file.lastIndexOf("_" + this.version + ".") > 0 ? this.file.substring(0, this.file.lastIndexOf("_" + this.version + ".")) : this.file.substring(0, this.file.lastIndexOf("."));
        }
        return this.basicFileName;
    }

    public ResourceInfo findResource(IResource resource) {
        int i = 0;
        while (i < this.children.size()) {
            String name = resource.getFullPath().toString();
            ResourceInfo resourceInfo = (ResourceInfo)this.children.get(i);
            if (name.equals(resourceInfo.file)) {
                return resourceInfo;
            }
            if ((resourceInfo = resourceInfo.findResource(resource)) != null) {
                return resourceInfo;
            }
            ++i;
        }
        return null;
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public static String toString(int[] version) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < version.length) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(Integer.toString(version[i]));
            ++i;
        }
        return sb.toString();
    }

    public ResourceInfo getPseudoChild(String id, String name, String file, String version) {
        String fileStart = file.lastIndexOf("_" + version + ".") > 0 ? file.substring(0, file.lastIndexOf("_" + version + ".")) : file.substring(0, file.lastIndexOf("."));
        int i = 0;
        while (i < this.children.size()) {
            ResourceInfo info = (ResourceInfo)this.children.get(i);
            if (info.getId().equals(id) && info.isPseudoNode() && fileStart.equalsIgnoreCase(info.getBasicFileName())) {
                return info;
            }
            ++i;
        }
        ResourceInfo info = new ResourceInfo(id, name, fileStart);
        this.add(info);
        return info;
    }

    public ResourceInfo getPseudoChild(int[] version) {
        int i = 0;
        while (i < this.children.size()) {
            ResourceInfo info = (ResourceInfo)this.children.get(i);
            if (info.isPseudoNode() && Arrays.equals(version, info.versionNumbers)) {
                return info;
            }
            ++i;
        }
        ResourceInfo info = new ResourceInfo(this.id, version);
        this.add(info);
        return info;
    }

    public int countPseudoNodes(String id) {
        int count = 0;
        int i = 0;
        while (i < this.children.size()) {
            ResourceInfo info = (ResourceInfo)this.children.get(i);
            if (info.id.equals(id) && info.pseudoNode) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public boolean hasSuccessors(ResourceInfo child) {
        int[] vs = child.getVersionNumbers();
        if (child.isPseudoNode()) {
            if (vs == null) {
                return false;
            }
            int i = 0;
            while (i < this.children.size()) {
                ResourceInfo resourceInfo = (ResourceInfo)this.children.get(i);
                if (resourceInfo.getVersionNumbers().length > vs.length) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.children.size()) {
                ResourceInfo resourceInfo = (ResourceInfo)this.children.get(i);
                if (resourceInfo.getVersionNumbers()[vs.length - 1] > vs[vs.length - 1]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void cleanUp(Comparator comparator) {
        block6: {
            if (this.children.size() <= 0) break block6;
            ResourceInfo[] infos = this.children.toArray(new ResourceInfo[this.children.size()]);
            Arrays.sort(infos, comparator);
            if (infos[0].isPseudoNode()) {
                int i = infos.length - 1;
                while (i >= 0) {
                    if (!infos[i].hasChildren()) {
                        this.remove(infos[i]);
                        --i;
                        continue;
                    }
                    break;
                }
            } else {
                int i = 0;
                while (i < infos.length) {
                    if (!infos[i].hasChildren() && infos[i].isVirtual()) {
                        this.remove(infos[i]);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

