/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.repository;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.modeling.core.views.repository.ResourceInfo;

public class ResourceSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    private ArrayList listeners = new ArrayList();
    private TreeViewer viewer;

    public ResourceSelectionProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.listeners.add(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, this.convertSelection((IStructuredSelection)event.getSelection()));
        int i = 0;
        while (i < this.listeners.size()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)this.listeners.get(i);
            listener.selectionChanged(newEvent);
            ++i;
        }
    }

    public ISelection getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return this.convertSelection(selection);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
                this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    public void setSelection(ISelection selection) {
    }

    private ISelection convertSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            Object[] objects = new Object[selection.size()];
            int c = 0;
            Iterator i = selection.iterator();
            while (i.hasNext()) {
                Path path;
                IProject project;
                IResource resource;
                ResourceInfo info;
                objects[c] = i.next();
                if (objects[c] instanceof ResourceInfo && (info = (ResourceInfo)objects[c]).getFile() != null && (resource = (project = (IProject)this.viewer.getInput()).findMember((path = new Path(info.getFile())).removeFirstSegments(1))) != null) {
                    objects[c] = resource;
                }
                ++c;
            }
            return new StructuredSelection(objects);
        }
        return selection;
    }
}

