/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.traverse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementTransfer;
import org.eclipse.stardust.modeling.core.editors.parts.IconFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.views.traverse.TraverseDragSourceListener;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class TraverseView
extends ViewPart {
    private IIdentifiableModelElement currentElement;
    private IIdentifiableModelElement element;
    private TableViewer traversalPathViewer;
    private TableViewer linkedObjectViewer;
    private List linkedObjectList = new ArrayList();
    private List traversalPathList = new ArrayList();
    private ISelectionListener selectionListener;

    public void createPartControl(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)3);
        this.createLinkedObjectGroup(composite);
        this.createTraversalPathGroup(composite);
        Button popButton = FormBuilder.createButton((Composite)composite, (String)Diagram_Messages.LB_TraverseView_Pop, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TraverseView.this.traversalPathList.isEmpty()) {
                    TraverseView.this.currentElement = (IIdentifiableModelElement)TraverseView.this.traversalPathList.get(TraverseView.this.traversalPathList.size() - 1);
                    TraverseView.this.resetTraversalPath();
                    TraverseView.this.traversalPathList.remove(TraverseView.this.traversalPathList.size() - 1);
                    IIdentifiableModelElement previousElement = TraverseView.this.traversalPathList.isEmpty() ? TraverseView.this.element : TraverseView.this.traversalPathList.get(TraverseView.this.traversalPathList.size() - 1);
                    TraverseView.this.traversalPathViewer.add(TraverseView.this.traversalPathList.toArray());
                    TraverseView.this.resetLinkedObjects();
                    TraverseView.this.addLinkedObjects(TraverseView.this.getLinkedElements((IModelElement)previousElement));
                }
            }
        });
        ((GridData)popButton.getLayoutData()).verticalAlignment = 0;
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.getSelectionListener());
    }

    public void dispose() {
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        super.dispose();
    }

    private ISelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    this.reset();
                    if (selection instanceof IStructuredSelection) {
                        IModelElementNodeSymbol symbol;
                        INodeSymbol nodeSymbol;
                        Object obj = ((IStructuredSelection)selection).getFirstElement();
                        if (obj instanceof AbstractEObjectTreeEditPart) {
                            Object model = ((AbstractEObjectTreeEditPart)obj).getModel();
                            if (model instanceof ActivityType || model instanceof OrganizationType || model instanceof RoleType) {
                                TraverseView.this.element = (IIdentifiableModelElement)model;
                            }
                        } else if (obj instanceof AbstractNodeSymbolEditPart && (nodeSymbol = (INodeSymbol)((AbstractNodeSymbolEditPart)obj).getModel()) instanceof IModelElementNodeSymbol && ((symbol = (IModelElementNodeSymbol)nodeSymbol).getModelElement() instanceof OrganizationType || symbol.getModelElement() instanceof RoleType || symbol.getModelElement() instanceof ActivityType)) {
                            TraverseView.this.element = symbol.getModelElement();
                        }
                        if (TraverseView.this.element != null) {
                            TraverseView.this.currentElement = TraverseView.this.element;
                            TraverseView.this.addLinkedObjects(TraverseView.this.getLinkedElements((IModelElement)TraverseView.this.currentElement));
                        }
                    }
                }

                private void reset() {
                    TraverseView.this.element = null;
                    TraverseView.this.resetLinkedObjects();
                    TraverseView.this.resetTraversalPath();
                    if (!TraverseView.this.traversalPathViewer.getControl().isDisposed()) {
                        TraverseView.this.traversalPathList.clear();
                    }
                }
            };
        }
        return this.selectionListener;
    }

    private void createTraversalPathGroup(Composite composite) {
        Composite comp = FormBuilder.createComposite((Composite)composite, (int)1);
        FormBuilder.createLabel((Composite)comp, (String)Diagram_Messages.LB_TraverseView_Path);
        Table table = new Table(comp, 2048);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.traversalPathViewer = new TableViewer(table);
        this.traversalPathViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IIdentifiableModelElement)element).getName();
            }

            public Image getImage(Object element) {
                return DiagramPlugin.getImage(IconFactory.getDefault().getIconFor((EObject)element));
            }
        });
        this.traversalPathViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.traversalPathViewer.addDragSupport(1, new Transfer[]{ModelElementTransfer.getInstance()}, (DragSourceListener)new TraverseDragSourceListener(this.traversalPathViewer));
    }

    private void createLinkedObjectGroup(Composite composite) {
        Composite comp = FormBuilder.createComposite((Composite)composite, (int)1);
        FormBuilder.createLabel((Composite)comp, (String)Diagram_Messages.LB_TraverseView_LinkedObjects);
        Table table = new Table(comp, 2048);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.linkedObjectViewer = new TableViewer(table);
        this.linkedObjectViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                element = element instanceof ParticipantType ? ((ParticipantType)element).getParticipant() : element;
                return ((IIdentifiableModelElement)element).getName();
            }

            public Image getImage(Object element) {
                return DiagramPlugin.getImage(IconFactory.getDefault().getIconFor((EObject)element));
            }
        });
        this.linkedObjectViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.linkedObjectViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    TraverseView.this.resetTraversalPath();
                    TraverseView.this.resetLinkedObjects();
                    TraverseView.this.currentElement = (IIdentifiableModelElement)((IStructuredSelection)event.getSelection()).getFirstElement();
                    TraverseView.this.addTraversalPath();
                    TraverseView.this.addLinkedObjects(TraverseView.this.getLinkedElements((IModelElement)TraverseView.this.currentElement));
                }
            }
        });
        this.linkedObjectViewer.addDragSupport(1, new Transfer[]{ModelElementTransfer.getInstance()}, (DragSourceListener)new TraverseDragSourceListener(this.linkedObjectViewer));
    }

    public void setFocus() {
    }

    private void addLinkedObjects(List list) {
        if (!this.linkedObjectViewer.getControl().isDisposed()) {
            this.linkedObjectList.addAll(list);
            this.linkedObjectViewer.add(this.linkedObjectList.toArray());
        }
    }

    private void addTraversalPath() {
        if (!this.traversalPathViewer.getControl().isDisposed()) {
            this.traversalPathList.add(this.currentElement);
            this.traversalPathViewer.add(this.traversalPathList.toArray());
        }
    }

    private List getLinkedElements(IModelElement modelElement) {
        List<IModelParticipant> list = new ArrayList();
        if (modelElement instanceof ActivityType) {
            list = ActivityUtil.getOutActivities((ActivityType)((ActivityType)modelElement));
            if (((ActivityType)modelElement).getApplication() != null) {
                list.add((IModelParticipant)((ActivityType)modelElement).getApplication());
            }
            if (((ActivityType)modelElement).getPerformer() != null) {
                list.add(((ActivityType)modelElement).getPerformer());
            }
            list.addAll(this.getDataTypes(((ActivityType)modelElement).getDataMapping()));
        } else {
            list = modelElement instanceof OrganizationType ? this.getOrganizationLinkedObj(modelElement) : this.getRoleLinkedObj(modelElement);
        }
        return list;
    }

    private List getDataTypes(EList dataMappingList) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        for (DataMappingType dataMapping : dataMappingList) {
            if (dataMapping.getData() == null) continue;
            list.add(dataMapping.getData());
        }
        return list;
    }

    private List getOrganizationLinkedObj(IModelElement modelElement) {
        ArrayList<IModelParticipant> list = new ArrayList<IModelParticipant>();
        Iterator iter = ((OrganizationType)modelElement).getParticipant().iterator();
        while (iter.hasNext()) {
            IModelParticipant element = ((ParticipantType)iter.next()).getParticipant();
            if (!(element instanceof RoleType) && !(element instanceof OrganizationType)) continue;
            list.add(element);
        }
        return list;
    }

    private List getRoleLinkedObj(IModelElement modelElement) {
        ArrayList<OrganizationType> list = new ArrayList<OrganizationType>();
        ModelType model = ModelUtils.findContainingModel((EObject)modelElement);
        for (OrganizationType organization : model.getOrganization()) {
            Iterator iterator = organization.getParticipant().iterator();
            while (iterator.hasNext()) {
                if (!((ParticipantType)iterator.next()).getParticipant().equals(modelElement)) continue;
                list.add(organization);
            }
        }
        return list;
    }

    private void resetTraversalPath() {
        if (!this.traversalPathViewer.getControl().isDisposed()) {
            this.traversalPathViewer.remove(this.traversalPathList.toArray());
            this.traversalPathViewer.refresh();
        }
    }

    private void resetLinkedObjects() {
        this.currentElement = null;
        if (!this.linkedObjectViewer.getControl().isDisposed()) {
            this.linkedObjectViewer.remove(this.linkedObjectList.toArray());
            this.linkedObjectList.clear();
            this.linkedObjectViewer.refresh();
        }
    }
}

