/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewWorkflowDiagramWizardPage
extends WizardPage {
    private String modelId = "";
    private String modelName = "";
    private String modelAuthor = "";
    private String modelDescription = "";
    private String containerName = "";
    private String fileName = "";
    private ISelection selection;
    private boolean completePage = true;
    private boolean currentProject = true;

    public NewWorkflowDiagramWizardPage(ISelection selection) {
        super("newModelPage");
        this.setTitle(Diagram_Messages.TITLE_NewCarnotWorkflowModel);
        this.setDescription(Diagram_Messages.DESC_CarnotWizard);
        this.selection = selection;
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length == 0) {
            this.currentProject = false;
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label lblModelName = new Label(container, 0);
        lblModelName.setText(Diagram_Messages.LB_ModelAndName);
        Text txtModelName = new Text(container, 2052);
        txtModelName.setLayoutData((Object)new GridData(768));
        new Label(container, 0);
        Label lblDescription = new Label(container, 0);
        lblDescription.setText(Diagram_Messages.LB_DESC_Description);
        Text txtDescription = new Text(container, 2114);
        txtDescription.setLayoutData((Object)new GridData(1808));
        txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkflowDiagramWizardPage.this.modelDescription = ((Text)e.widget).getText();
            }
        });
        new Label(container, 0);
        Label lblFolder = new Label(container, 0);
        lblFolder.setText(Diagram_Messages.LB_Folder);
        final Text txtFolder = new Text(container, 2052);
        GridData gd = new GridData(768);
        txtFolder.setLayoutData((Object)gd);
        Button btnBrowsFolder = new Button(container, 8);
        btnBrowsFolder.setText(Diagram_Messages.TXT_Browse);
        btnBrowsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWorkflowDiagramWizardPage.this.handleBrowse(txtFolder);
            }
        });
        if (!this.currentProject) {
            btnBrowsFolder.setEnabled(false);
        }
        final Button btnAdvanced = new Button(container, 8);
        btnAdvanced.setText(Diagram_Messages.TXT_AdvancedRight);
        new Label(container, 0).setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        final Composite pnlAdvanced = new Composite(container, 0);
        pnlAdvanced.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        GridLayout layoutPnlAdvanced = new GridLayout();
        pnlAdvanced.setLayout((Layout)layoutPnlAdvanced);
        layoutPnlAdvanced.numColumns = 2;
        layoutPnlAdvanced.verticalSpacing = 9;
        Label lblModelId = new Label(pnlAdvanced, 0);
        lblModelId.setText(Diagram_Messages.LB_ModelAndId);
        final Text txtModelId = new Text(pnlAdvanced, 2052);
        txtModelId.setLayoutData((Object)new GridData(768));
        txtModelId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkflowDiagramWizardPage.this.modelId = ((Text)e.widget).getText();
                NewWorkflowDiagramWizardPage.this.dialogChanged();
            }
        });
        txtModelId.setText("New_Workflow_Model");
        txtFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkflowDiagramWizardPage.this.containerName = ((Text)e.widget).getText();
                NewWorkflowDiagramWizardPage.this.dialogChanged();
            }
        });
        txtModelName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkflowDiagramWizardPage.this.modelName = ((Text)e.widget).getText();
                txtModelId.setText(ModelUtils.computeId((String)NewWorkflowDiagramWizardPage.this.modelName));
                NewWorkflowDiagramWizardPage.this.dialogChanged();
            }
        });
        txtModelName.setText(Diagram_Messages.LB_NewWorkflowModel);
        if (!this.currentProject) {
            txtFolder.setEnabled(false);
        } else {
            this.initializeSelection(txtFolder);
        }
        Label lblAuthor = new Label(pnlAdvanced, 0);
        lblAuthor.setText(Diagram_Messages.TXT_Author);
        final Text txtAuthor = new Text(pnlAdvanced, 2052);
        txtAuthor.setLayoutData((Object)new GridData(768));
        txtAuthor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkflowDiagramWizardPage.this.modelAuthor = ((Text)e.widget).getText();
            }
        });
        txtAuthor.setText(System.getProperty("user.name"));
        Label lblFileName = new Label(pnlAdvanced, 0);
        lblFileName.setText(Diagram_Messages.TXT_FileName);
        final Text txtFileName = new Text(pnlAdvanced, 2052);
        txtFileName.setLayoutData((Object)new GridData(768));
        txtFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkflowDiagramWizardPage.this.fileName = ((Text)e.widget).getText();
                NewWorkflowDiagramWizardPage.this.dialogChanged();
            }
        });
        pnlAdvanced.setVisible(false);
        btnAdvanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pnlAdvanced.setVisible(!pnlAdvanced.isVisible());
                btnAdvanced.setText(pnlAdvanced.isVisible() ? Diagram_Messages.TXT_AdvancedLeft : Diagram_Messages.TXT_AdvancedRight);
                if (!pnlAdvanced.isVisible()) {
                    txtAuthor.setText(System.getProperty("user.name"));
                    NewWorkflowDiagramWizardPage.this.modelAuthor = txtAuthor.getText();
                    txtFileName.setText("");
                    NewWorkflowDiagramWizardPage.this.fileName = txtFileName.getText();
                } else {
                    txtFileName.setText(String.valueOf(txtModelId.getText()) + ".xpdl");
                    NewWorkflowDiagramWizardPage.this.fileName = txtFileName.getText();
                }
            }
        });
        if (!this.completePage) {
            this.setPageComplete(false);
        }
        this.setControl((Control)container);
    }

    private void initializeSelection(Text containerText) {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                this.setContainerText((IResource)obj, containerText);
            } else if (obj instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
                this.setContainerText(resource, containerText);
            }
        } else {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (root.getProjects().length == 1) {
                this.setContainerText((IResource)root.getProjects()[0], containerText);
            }
        }
    }

    private void setContainerText(IResource resource, Text containerText) {
        if (resource != null) {
            IContainer resourceContainer = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
            containerText.setText(resourceContainer.getFullPath().toString());
        } else {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (root.getProjects().length == 1) {
                this.setContainerText((IResource)root.getProjects()[0], containerText);
            }
        }
    }

    private void handleBrowse(Text containerText) {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Diagram_Messages.MSG_SelectNewFileContainer);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        boolean isRoot;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String message = null;
        boolean bl = isRoot = container == null || container.getProject() == null;
        if (this.containerName.length() == 0 && this.currentProject) {
            message = Diagram_Messages.NewWorkflowDiagramWizardPage_MSG_FolderMustNotBeEmpty;
        } else if (this.currentProject && (container == null || !(container instanceof IContainer) || isRoot)) {
            message = Diagram_Messages.MSG_FolderMustExist;
        }
        if (StringUtils.isEmpty((String)this.modelId)) {
            message = Diagram_Messages.MSG_ValidModelIDMustBeSpecified;
        } else if (StringUtils.isEmpty((String)this.modelName)) {
            message = Diagram_Messages.MSG_ValidModelNameMustBeSpecified;
        } else if (!StringUtils.isEmpty((String)this.fileName)) {
            if (this.fileName.replace('\\', '/').indexOf(47, 1) > 0) {
                message = Diagram_Messages.MSG_ModelFileNameMustBeValid;
            } else {
                String ext;
                int dotLoc = this.fileName.lastIndexOf(46);
                if (dotLoc != -1 && !(ext = this.fileName.substring(dotLoc + 1)).equalsIgnoreCase("xpdl") && !ext.equalsIgnoreCase("cwm")) {
                    message = Diagram_Messages.MSG_WrongFileExtension;
                }
            }
        }
        this.setErrorMessage(message);
        if (this.completePage) {
            this.setPageComplete(message == null);
        } else {
            this.setPageComplete(false);
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelAuthor() {
        return this.modelAuthor;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getFileName() {
        return StringUtils.isEmpty((String)this.fileName) ? String.valueOf(this.getModelId()) + ".xpdl" : this.fileName;
    }
}

