/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.wizards.ExportLocationPage;
import org.eclipse.stardust.modeling.data.structured.wizards.TypeDeclarationsSelectionPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Document;

public class ExportSchemaWizard
extends Wizard
implements INewWizard {
    private static final String XSD_FILE_SUFFIX = ".xsd";
    private TypeDeclarationsSelectionPage typesPage;
    private ExportLocationPage locationPage;

    public ExportSchemaWizard(TypeDeclarationType typeDeclaration) {
        String title = Structured_Messages.ExportSchemaWizardTitle;
        this.setWindowTitle(title);
        this.setDefaultPageImageDescriptor(DiagramPlugin.imageDescriptorFromPlugin((String)"org.eclipse.xsd.editor", (String)"icons/full/wizban/NewXSD.gif"));
        this.setNeedsProgressMonitor(true);
        this.typesPage = new TypeDeclarationsSelectionPage(typeDeclaration);
        this.typesPage.setTitle(title);
        this.typesPage.setDescription(Structured_Messages.TypesPageDescription);
        this.locationPage = new ExportLocationPage();
        this.locationPage.setTitle(title);
        this.locationPage.setDescription(Structured_Messages.LocationPageDescription);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
    }

    public void addPages() {
        if (this.typesPage.getTypes2Save().size() > 1) {
            this.addPage((IWizardPage)this.typesPage);
        }
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean canFinish() {
        return this.locationPage.isPageComplete();
    }

    public boolean performFinish() {
        final IFolder location = this.locationPage.getSaveFolder();
        final List<TypeDeclarationType> types = this.typesPage.getTypes2Save();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                /*
                 * Unable to fully structure code
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Structured_Messages.ExportingTaskName, types.size() * 3);
                    i = 0;
                    while (i < types.size() && !monitor.isCanceled()) {
                        declaration = (TypeDeclarationType)types.get(i);
                        monitor.subTask(declaration.getName());
                        schema = declaration.getSchemaType().getSchema();
                        changedImports = CollectionUtils.newList();
                        contents = schema.getContents();
                        for (XSDSchemaContent item : contents) {
                            if (!(item instanceof XSDImport) || (schemaLocation = (xsdImport = (XSDImport)item).getSchemaLocation()) == null || !schemaLocation.startsWith("urn:internal:")) continue;
                            xsdImport.setSchemaLocation(String.valueOf(schemaLocation.substring("urn:internal:".length())) + ".xsd");
                            changedImports.add(xsdImport);
                        }
                        monitor.worked(1);
                        try {
                            ExportSchemaWizard.access$0(ExportSchemaWizard.this, String.valueOf(declaration.getId()) + ".xsd", schema, location, monitor);
                        }
                        finally {
                            ** for (xsdImport : changedImports)
                        }
lbl-1000:
                        // 1 sources

                        {
                            schemaLocation = xsdImport.getSchemaLocation();
                            xsdImport.setSchemaLocation("urn:internal:" + schemaLocation.substring(0, schemaLocation.length() - ".xsd".length()));
                            continue;
                        }
lbl24:
                        // 1 sources

                        ++i;
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void doSaveSchema(String xsdFileName, XSDSchema schema, IFolder location, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IFile file = location.getFile(xsdFileName);
        schema.updateElement();
        if (file.exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.SKIP_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = NLS.bind((String)IDEWorkbenchMessages.SaveAsDialog_overwriteQuestion, (Object)file.getFullPath().toOSString());
            MessageDialog dialog = new MessageDialog(this.getShell(), IDEWorkbenchMessages.Question, null, question, 3, buttons, 0);
            switch (dialog.open()) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    monitor.setCanceled(true);
                    return;
                }
            }
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XSDResourceImpl.serialize((OutputStream)outputStream, (Document)schema.getDocument(), (String)"UTF-8");
            monitor.worked(1);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            if (file.exists()) {
                file.setContents((InputStream)inputStream, 2, null);
            } else {
                file.create((InputStream)inputStream, 2, null);
            }
            monitor.worked(1);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ void access$0(ExportSchemaWizard exportSchemaWizard, String string, XSDSchema xSDSchema, IFolder iFolder, IProgressMonitor iProgressMonitor) {
        exportSchemaWizard.doSaveSchema(string, xSDSchema, iFolder, iProgressMonitor);
    }

    private static class IDEWorkbenchMessages
    extends NLS {
        private static final String BUNDLE_NAME = "org.eclipse.ui.internal.ide.messages";
        public static String SaveAsDialog_overwriteQuestion;
        public static String Question;

        static {
            NLS.initializeMessages((String)BUNDLE_NAME, IDEWorkbenchMessages.class);
        }

        private IDEWorkbenchMessages() {
        }
    }
}

