/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.deploy;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.stardust.common.error.ValidationException;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.Inconsistency;
import org.eclipse.stardust.engine.api.query.DeployedModelQuery;
import org.eclipse.stardust.engine.api.runtime.Daemon;
import org.eclipse.stardust.engine.api.runtime.DeployedModelDescription;
import org.eclipse.stardust.engine.api.runtime.DeploymentElement;
import org.eclipse.stardust.engine.api.runtime.DeploymentException;
import org.eclipse.stardust.engine.api.runtime.DeploymentOptions;
import org.eclipse.stardust.engine.api.runtime.Models;
import org.eclipse.stardust.engine.api.runtime.ServiceFactory;
import org.eclipse.stardust.engine.cli.common.DeploymentCallback;
import org.eclipse.stardust.engine.cli.common.DeploymentUtils;
import org.eclipse.stardust.engine.core.compatibility.gui.AbstractDialog;
import org.eclipse.stardust.engine.core.compatibility.gui.ValidationExceptionDialog;
import org.eclipse.stardust.modeling.deploy.Deploy_Messages;
import org.eclipse.stardust.modeling.deploy.DeployedModelsView;
import org.eclipse.stardust.modeling.deploy.RuntimeUtil;

public class DeployModelDialog
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String OVERWRITE_CARD = "overwrite";
    private static final String DEPLOY_CARD = "deploy";
    private ServiceFactory sf;
    private JRadioButton overwriteButton;
    private JRadioButton deployButton;
    private CardLayout card;
    private JPanel listPanel;
    private DeployedModelsView deployView;
    private DeployedModelsView overwriteView;
    private Models data;
    private boolean wasDeployed = false;
    private List<File> modelFiles;

    public DeployModelDialog(JFrame parent, ServiceFactory service, List<File> modelFiles, List<IModel> models) {
        super((Frame)parent);
        this.sf = service;
        this.modelFiles = modelFiles;
        this.data = this.sf.getQueryService().getModels(DeployedModelQuery.findAll());
        if (!this.data.isEmpty() && models.size() == 1) {
            this.overwriteView.setData((List<DeployedModelDescription>)this.data, models, true);
            this.overwriteButton.setEnabled(true);
        } else {
            this.overwriteButton.setEnabled(false);
        }
        this.deployView.setData((List<DeployedModelDescription>)this.data, models, false);
        this.deployButton.setSelected(true);
        this.card.show(this.listPanel, DEPLOY_CARD);
    }

    protected JComponent createContent() {
        this.overwriteButton = new JRadioButton(new AbstractAction(Deploy_Messages.getString("LB_Overwrite")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployModelDialog.this.card.show(DeployModelDialog.this.listPanel, DeployModelDialog.OVERWRITE_CARD);
            }
        });
        this.deployButton = new JRadioButton(new AbstractAction(Deploy_Messages.getString("LB_DeployVersion")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployModelDialog.this.card.show(DeployModelDialog.this.listPanel, DeployModelDialog.DEPLOY_CARD);
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.overwriteButton);
        group.add(this.deployButton);
        JPanel mainPanel = new JPanel(new BorderLayout());
        Box options = new Box(0);
        options.add(new JLabel(Deploy_Messages.getString("LB_Action")));
        options.add(this.deployButton);
        options.add(this.overwriteButton);
        mainPanel.add((Component)options, "North");
        this.card = new CardLayout();
        this.listPanel = new JPanel(this.card);
        this.overwriteView = new DeployedModelsView();
        this.listPanel.add((Component)this.overwriteView, OVERWRITE_CARD);
        this.deployView = new DeployedModelsView();
        this.listPanel.add((Component)this.deployView, DEPLOY_CARD);
        mainPanel.add(this.listPanel);
        return mainPanel;
    }

    public void validateSettings() throws ValidationException {
        if (this.overwriteButton.isSelected() && this.overwriteView.getSelectedModelOID() == -1) {
            throw new ValidationException(Deploy_Messages.getString("MSG_NoModelToOverwrite"), false);
        }
    }

    public void onOK() {
        try {
            if (this.overwriteButton.isSelected()) {
                this.overwrite();
            } else {
                this.deploy();
            }
        }
        catch (DeploymentException deploymentException) {}
    }

    private void deploy() {
        MyDeploymentCallback callback = new MyDeploymentCallback();
        DeploymentOptions options = new DeploymentOptions();
        options.setValidFrom(this.deployView.getValidFrom());
        options.setComment(this.deployView.getComment());
        List<DeploymentElement> units = null;
        try {
            units = RuntimeUtil.createDeploymentElements(this.modelFiles);
        }
        catch (IOException ex) {
            callback.reportErrors(Collections.singletonList(new Inconsistency(ex.getMessage(), null, 1)));
            return;
        }
        DeploymentUtils.deployFromFiles((ServiceFactory)this.sf, (DeploymentCallback)callback, units, (DeploymentOptions)options);
        this.wasDeployed = true;
    }

    private void overwrite() {
        MyDeploymentCallback callback = new MyDeploymentCallback();
        DeploymentOptions options = new DeploymentOptions();
        options.setComment(this.deployView.getComment());
        DeploymentElement unit = null;
        try {
            unit = RuntimeUtil.createDeploymentElement(this.modelFiles.get(0));
        }
        catch (IOException ex) {
            callback.reportErrors(Collections.singletonList(new Inconsistency(ex.getMessage(), null, 1)));
            return;
        }
        DeploymentUtils.overwriteFromFile((ServiceFactory)this.sf, (DeploymentCallback)callback, (DeploymentElement)unit, (int)this.overwriteView.getSelectedModelOID(), (DeploymentOptions)options);
        this.wasDeployed = true;
    }

    private boolean ignoreWarnings(List<Inconsistency> warnings) {
        boolean isDaemonRunning = false;
        ValidationException e = new ValidationException(Deploy_Messages.getString("MSG_ContinueDeploying"), warnings, true);
        List daemons = this.sf.getAdministrationService().getAllDaemons(true);
        for (Daemon daemon : daemons) {
            if (!daemon.isRunning()) continue;
            isDaemonRunning = true;
            JOptionPane.showMessageDialog((Component)((Object)this), Deploy_Messages.getString("MSG_DeploymentNotPossible"), Deploy_Messages.getString("TITLE_Warning"), 2);
        }
        return isDaemonRunning ? false : ValidationExceptionDialog.showDialog((Component)((Object)this), (ValidationException)e, (boolean)false);
    }

    private void showErrors(List<Inconsistency> errors) {
        ValidationException e = new ValidationException(Deploy_Messages.getString("MSG_NoErrors"), errors, false);
        ValidationExceptionDialog.showDialog((Component)((Object)this), (ValidationException)e);
    }

    public static boolean showDialog(ServiceFactory service, List<File> modelFiles, List<IModel> models, JFrame parent) {
        DeployModelDialog instance = new DeployModelDialog(parent, service, modelFiles, models);
        DeployModelDialog.showDialog((String)Deploy_Messages.getString("DIALOG_Model"), (AbstractDialog)instance, (JFrame)parent);
        return instance.wasDeployed;
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = super.createButtonPanel();
        this.okButton.setText(Deploy_Messages.getString("BUT_TXT_OK"));
        this.cancelButton.setText(Deploy_Messages.getString("BUT_TXT_CANCEL"));
        return buttonPanel;
    }

    private class MyDeploymentCallback
    implements DeploymentCallback {
        private MyDeploymentCallback() {
        }

        public void reportErrors(List<Inconsistency> errors) {
            DeployModelDialog.this.showErrors(errors);
        }

        public boolean reportWarnings(List<Inconsistency> warnings) {
            return DeployModelDialog.this.ignoreWarnings(warnings);
        }
    }
}

