/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.ejb30.session;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.integration.ejb30.EJB30_Messages;
import org.eclipse.stardust.modeling.integration.ejb30.MethodSelector;
import org.eclipse.stardust.modeling.integration.ejb30.TypeSelector;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SessionBean30PropertyPage
extends AbstractModelElementPropertyPage {
    private static final String BLANK_STRING = " ";
    private static final String[] FILTERABLES = new String[]{Serializable.class.getName(), Externalizable.class.getName()};
    private static final List<String> FILTERABLES_LIST = Arrays.asList(FILTERABLES);
    private TypeSelector.TextSelector beanBrowser;
    private TypeSelector.ComboSelector interfaceBrowser;
    private MethodSelector creationBrowser;
    private MethodSelector completionBrowser;
    private LabeledText beanText;
    private LabeledCombo interfaceCombo;
    private LabeledText jndiText;
    private LabelWithStatus creationLabel;
    private LabelWithStatus completionLabel;

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.beanText, (IExtensibleElement)element, "carnot:engine:className");
        wBndMgr.bind(this.interfaceCombo, (IExtensibleElement)element, "carnot:engine:remoteInterface");
        wBndMgr.bind(this.jndiText, (IExtensibleElement)element, "carnot:engine:jndiPath");
        wBndMgr.getValidationBindingManager().bind((EObject)element, (Object)"carnot:engine:createMethodName", this.creationLabel);
        wBndMgr.getValidationBindingManager().bind((EObject)element, (Object)"carnot:engine:methodName", this.completionLabel);
        this.creationBrowser.setMethodName(AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:createMethodName"));
        this.completionBrowser.setMethodName(AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName"));
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:createMethodName", (String)this.creationBrowser.getMethodName());
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName", (String)this.completionBrowser.getMethodName());
    }

    public Control createBody(Composite parent) {
        TypeFinder finder = new TypeFinder(this.getModelElement());
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        LabelWithStatus beanLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)EJB30_Messages.SESSION_BEAN30_PROPERTY_PAGE_LABEL_BEAN_CLASS);
        this.beanBrowser = new TypeSelector.TextSelector(finder, composite, EJB30_Messages.SESSION_BEAN30_PROPERTY_PAGE_TITLE_BEAN_CLASS, 2);
        this.beanText = new LabeledText(this.beanBrowser.getTextControl(), beanLabel);
        LabelWithStatus remoteLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)EJB30_Messages.SESSION_BEAN30_PROPERTY_PAGE_LABEL_BUSINESS_INTERFACE);
        this.interfaceBrowser = new TypeSelector.ComboSelector(finder, composite, EJB30_Messages.SESSION_BEAN30_PROPERTY_PAGE_TITLE_BUSINESS_INTERFACE, 4);
        this.interfaceCombo = new LabeledCombo(this.interfaceBrowser.getComboControl(), remoteLabel);
        this.jndiText = FormBuilder.createLabeledText((Composite)composite, (String)EJB30_Messages.SESSION_BEAN30_PROPERTY_PAGE_LABEL_JNDI_PATH);
        FormBuilder.createLabel((Composite)composite, (String)BLANK_STRING, (int)2);
        this.creationLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)EJB30_Messages.SESSION_BEAN30_PROPERTY_PAGE_LABEL_INITIALIZATION_METHOD);
        this.creationBrowser = new MethodSelector(composite);
        this.completionLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)EJB30_Messages.SESSION_BEAN30_PROPERTY_PAGE_LABEL_COMPLETION_METHOD);
        this.completionBrowser = new MethodSelector(composite);
        this.beanBrowser.addListener(new TypeSelector.TypeListener(){

            @Override
            public void typeChanged(TypeInfo type) {
                SessionBean30PropertyPage.this.updateInterfaces(type);
            }
        });
        this.interfaceBrowser.addListener(new TypeSelector.TypeListener(){

            @Override
            public void typeChanged(TypeInfo type) {
                SessionBean30PropertyPage.this.updateMethods(type);
            }
        });
        return composite;
    }

    protected void updateMethods(TypeInfo type) {
        List allMethods = Collections.emptyList();
        try {
            allMethods = type.getMethods();
        }
        catch (Exception exception) {}
        ArrayList<Object> copy = new ArrayList<MethodInfo>(allMethods);
        this.filter(copy, DirectionType.IN_LITERAL);
        this.creationBrowser.setMethodsList(copy);
        copy = new ArrayList(allMethods);
        this.filter(copy, DirectionType.INOUT_LITERAL);
        this.completionBrowser.setMethodsList(copy);
    }

    protected void updateInterfaces(TypeInfo type) {
        List interfaces = type == null ? Collections.emptyList() : type.getInterfaces();
        this.filter(interfaces);
        this.interfaceBrowser.setTypesList(interfaces);
    }

    private void filter(List<MethodInfo> methods, DirectionType direction) {
        int i = methods.size() - 1;
        while (i >= 0) {
            MethodInfo method = methods.get(i);
            if (!method.isAccessible()) {
                methods.remove(method);
            } else if (DirectionType.IN_LITERAL.equals((Object)direction) && method.getParameterCount() == 0 && method.hasReturn()) {
                methods.remove(method);
            }
            --i;
        }
    }

    private void filter(List<TypeInfo> interfaces) {
        int i = interfaces.size() - 1;
        while (i >= 0) {
            TypeInfo iface = interfaces.get(i);
            if (FILTERABLES_LIST.contains(iface.getFullName())) {
                interfaces.remove(iface);
            }
            --i;
        }
    }
}

