/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.mail.application;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.extensions.mail.utils.MailValidationUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.integration.mail.Mail_Messages;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;

public class MailValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        List result = CollectionUtils.newList();
        if (element instanceof ApplicationType) {
            ApplicationType application = (ApplicationType)element;
            this.checkProperty(application, "fromAddress", "carnot:engine:mail:defaultMailFrom", Mail_Messages.TXT_NO_SENDER_MAIL_ADDRESS_SPECIFIED, result);
            this.checkProperty(application, "toAddress", "carnot:engine:mail:defaultMailTo", Mail_Messages.TXT_NO_RECEIVER_MAIL_ADDRESS_SPECIFIED, result);
            List tmpResult = CollectionUtils.newList();
            this.checkProperty(application, "mailServer", "carnot:engine:mail:defaultMailServer", Mail_Messages.TXT_NO_MAIL_SERVER_SPECIFIED, tmpResult);
            this.checkProperty(application, "jndiSession", "carnot:engine:mail:defaultJNDISession", Mail_Messages.TXT_NO_JNDI_SESSION_SPECIFIED, tmpResult);
            if (tmpResult.size() >= 2) {
                result.addAll(tmpResult);
            }
            this.validateMailAddress(application, "carnot:engine:mail:defaultMailFrom", result);
            this.validateMailAddress(application, "carnot:engine:mail:defaultMailTo", result);
            this.validateMailAddress(application, "carnot:engine:mail:defaultMailBCC", result);
            this.validateMailAddress(application, "carnot:engine:mail:defaultMailCC", result);
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private void checkProperty(ApplicationType application, String accessPoint, String att, String msg, List<Issue> result) {
        EList executedActivities = application.getExecutedActivities();
        boolean hasAccessPoints = false;
        for (ActivityType activity : executedActivities) {
            hasAccessPoints = false;
            if (!ActivityUtil.isApplicationActivity((ActivityType)activity)) continue;
            List dataMappings = ActivityUtil.getDataMappings((ActivityType)activity, (boolean)true, (String)"application");
            hasAccessPoints = dataMappings.isEmpty() ? false : hasAccessPoints;
            for (DataMappingType dataMapping : dataMappings) {
                if (!accessPoint.equals(dataMapping.getApplicationAccessPoint())) continue;
                hasAccessPoints = true;
            }
            if (!hasAccessPoints) break;
        }
        if (!hasAccessPoints && StringUtils.isEmpty((String)AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)att))) {
            result.add(Issue.error((EObject)application, (String)msg, (Object)att));
        }
    }

    private void validateMailAddress(ApplicationType application, String att, List<Issue> result) {
        boolean isValid = true;
        String mailList = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)att);
        if (mailList != null) {
            mailList = VariableContextHelper.getInstance().getContext((ModelType)application.eContainer()).replaceAllVariablesByDefaultValue(mailList);
        }
        Iterator i = StringUtils.split((String)mailList, (char)';');
        while (i.hasNext()) {
            String mail = (String)i.next();
            if (StringUtils.isEmpty((String)mail) || MailValidationUtils.isValidEMail((String)mail)) continue;
            isValid = false;
        }
        if (!isValid) {
            result.add(Issue.warning((EObject)application, (String)Mail_Messages.TXT_INVALID_MAIL_ADRESS, (Object)att));
        }
    }
}

