/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.javascript.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;

public class EditorUtils {
    public static IFile createFileStructure(IProject project, ModelType model, String jsFileName) {
        String id = "." + model.getId();
        IFile tempFileResource = null;
        try {
            IFolder kwFolder = project.getFolder(id);
            if (!kwFolder.exists()) {
                kwFolder.create(true, true, null);
            }
            String filePath = String.valueOf(kwFolder.getLocation().toString()) + "/" + jsFileName;
            tempFileResource = null;
            File tempFile = new File(filePath);
            if (!tempFile.exists()) {
                tempFile.createNewFile();
            }
            if (!(tempFileResource = kwFolder.getFile(jsFileName)).exists()) {
                tempFileResource.create((InputStream)new FileInputStream(tempFile), true, null);
            }
        }
        catch (Exception exception) {}
        return tempFileResource;
    }

    public static void addJSSupport(IProject project, ModelType model) throws CoreException {
        if (project != null && !project.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[newNatures.length - 1] = "org.eclipse.wst.jsdt.core.jsNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.stardust.modeling.javascript.editor");
        URL url = BundleUtility.find((Bundle)bundle, (String)"lib/.jsdtscope");
        IFile systemJSResource = project.getFile(".jsdtscope");
        if (!systemJSResource.exists()) {
            try {
                systemJSResource.create(url.openStream(), true, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
    }

    public static void deleteFileStructure(IProject project, ModelType model) {
        String id = "." + model.getId();
        IFolder modelFolder = project.getFolder(id);
        if (modelFolder.exists()) {
            try {
                modelFolder.delete(true, false, null);
            }
            catch (Exception exception) {}
        }
    }
}

