/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.javascript.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.stardust.modeling.javascript.editor.CancelableJSProblemFactory;
import org.eclipse.stardust.modeling.javascript.editor.JavaScriptProblemFinder;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CancelableNameEnvironment;
import org.eclipse.wst.jsdt.internal.core.JavaProject;

public class JavaScriptValidator {
    private IJavaScriptProject project;
    private ICompilationUnit compilationUnit;
    private CancelableNameEnvironment environment;
    private IErrorHandlingPolicy policy;
    private CompilerOptions compilerOptions;
    private ICompilerRequestor requestor;
    private CancelableJSProblemFactory problemFactory;
    private JavaScriptProblemFinder problemFinder;

    public JavaScriptValidator(IJavaScriptProject project) {
        this.project = (JavaProject)project;
        try {
            this.environment = new CancelableNameEnvironment((JavaProject)project, null, null, null);
        }
        catch (JavaScriptModelException e) {
            e.printStackTrace();
        }
        this.policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        this.compilerOptions = this.getCompilerOptions(project.getOptions(true), false, false);
        this.requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
        this.problemFactory = new CancelableJSProblemFactory(null);
        this.problemFinder = new JavaScriptProblemFinder((INameEnvironment)this.environment, this.policy, this.compilerOptions, this.requestor, (IProblemFactory)this.problemFactory);
    }

    public synchronized IProblem[] validate(String code) {
        try {
            BasicCompilationUnit bcu = new BasicCompilationUnit(code.toCharArray(), this.getPackageName("com.test.validation.class"), "");
            CompilationUnitDeclaration result = this.problemFinder.resolve((ICompilationUnit)bcu, true, true, true);
            CategorizedProblem[] problems = result.compilationResult.getErrors();
            if (problems != null && problems.length > 0) {
                problems = this.filterProblems((IProblem[])problems);
            }
            return problems;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private IProblem[] filterProblems(IProblem[] problems) {
        ArrayList<IProblem> filteredProblems = new ArrayList<IProblem>();
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            if (problem.getMessage().indexOf("The return type is incompatible") <= -1) {
                filteredProblems.add(problem);
            }
            ++i;
        }
        int j = 0;
        IProblem[] realProblems = new IProblem[filteredProblems.size()];
        Iterator i2 = filteredProblems.iterator();
        while (i2.hasNext()) {
            realProblems[j++] = (IProblem)i2.next();
        }
        return realProblems;
    }

    private CompilerOptions getCompilerOptions(Map settings, boolean creatingAST, boolean statementsRecovery) {
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        compilerOptions.performMethodsFullRecovery = statementsRecovery;
        compilerOptions.performStatementsRecovery = statementsRecovery;
        compilerOptions.parseLiteralExpressionsAsConstants = !creatingAST;
        compilerOptions.storeAnnotations = creatingAST;
        return compilerOptions;
    }

    public char[][] getPackageName(String className) {
        StringTokenizer izer = new StringTokenizer(className, ".");
        char[][] result = new char[izer.countTokens() - 1][];
        int i = 0;
        while (i < result.length) {
            String tok = izer.nextToken();
            result[i] = tok.toCharArray();
            ++i;
        }
        return result;
    }
}

