/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stardust.modeling.modelimport.ISourceGroupProvider;

public class ImportExtensionRegistry {
    private static ImportExtensionRegistry instance;
    private HashMap extRegistry = new HashMap();
    private HashMap sgpRegistry = new HashMap();

    public void reset() {
        this.sgpRegistry.clear();
    }

    public static ImportExtensionRegistry instance() {
        if (instance == null) {
            instance = new ImportExtensionRegistry();
        }
        return instance;
    }

    public Map getExtensions(String extensionPointId) {
        TreeMap extensions = (TreeMap)this.extRegistry.get(extensionPointId);
        if (extensions == null) {
            extensions = new TreeMap();
            this.extRegistry.put(extensionPointId, extensions);
            this.addExternalExtensions(extensions, extensionPointId);
        }
        return extensions;
    }

    public Map getSourceGroupProviders(String extensionPointId) {
        TreeMap<String, ISourceGroupProvider> sourceGroupProviders = (TreeMap<String, ISourceGroupProvider>)this.sgpRegistry.get(extensionPointId);
        if (sourceGroupProviders == null) {
            sourceGroupProviders = new TreeMap<String, ISourceGroupProvider>();
            for (String key : this.getExtensions(extensionPointId).keySet()) {
                IConfigurationElement element = (IConfigurationElement)this.getExtensions(extensionPointId).get(key);
                try {
                    ISourceGroupProvider provider = null;
                    provider = (ISourceGroupProvider)element.createExecutableExtension("class");
                    sourceGroupProviders.put(key, provider);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.sgpRegistry.put(extensionPointId, sourceGroupProviders);
        }
        return sourceGroupProviders;
    }

    private void addExternalExtensions(Map extensions, String extensionPointId) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        String expandedId = "org.eclipse.stardust.modeling.modelimport." + extensionPointId;
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(expandedId);
        IExtension[] extension = extensionPoint.getExtensions();
        int i = 0;
        while (i < extension.length) {
            IConfigurationElement[] configuration = extension[i].getConfigurationElements();
            int j = 0;
            while (j < configuration.length) {
                String id = configuration[j].getAttribute("name");
                extensions.put(id, configuration[j]);
                ++j;
            }
            ++i;
        }
    }

    public static void stop() {
        if (instance != null) {
            ImportExtensionRegistry.instance.extRegistry.clear();
            ImportExtensionRegistry.instance.sgpRegistry.clear();
        }
    }
}

