/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.modeling.modelimport.FileSystemStore;
import org.eclipse.stardust.modeling.modelimport.ModelNode;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ResourceListAndTreeGroup
implements ICheckStateListener {
    private FileSystemStore root;
    private Map checkedStateStore = new HashMap(9);
    private ListenerList listeners = new ListenerList();
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;
    private static int PREFERRED_HEIGHT = 150;

    public ResourceListAndTreeGroup(Composite parent, FileSystemStore rootObject, int style, boolean useHeightHint) {
        this.root = rootObject;
        this.createContents(parent, style, useHeightHint);
    }

    public void checkStateChanged(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (event.getCheckable().equals(ResourceListAndTreeGroup.this.treeViewer)) {
                    ResourceListAndTreeGroup.this.treeItemChecked((ModelNode)event.getElement(), event.getChecked());
                } else {
                    ResourceListAndTreeGroup.this.listItemChecked((ModelNode)event.getElement(), event.getChecked());
                }
                ResourceListAndTreeGroup.this.notifyCheckStateChangeListeners(event);
            }
        });
    }

    protected void createContents(Composite parent, int style, boolean useHeightHint) {
        Composite composite = new Composite(parent, style);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createListViewer(composite, useHeightHint);
        this.createTreeViewer(composite, useHeightHint);
        this.initialize();
    }

    protected void createListViewer(Composite parent, boolean useHeightHint) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((FileSystemStore)inputElement).getRootModels();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ModelNode node = (ModelNode)element;
                return node.getId();
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ModelNode node = (ModelNode)selection.getFirstElement();
                if (node == null) {
                    ResourceListAndTreeGroup.this.treeViewer.setInput((Object)new ModelNode[0]);
                } else {
                    ResourceListAndTreeGroup.this.treeViewer.setInput((Object)new ModelNode[]{node});
                    ResourceListAndTreeGroup.this.treeViewer.expandAll();
                    Set checked = (Set)ResourceListAndTreeGroup.this.checkedStateStore.get(node.getId());
                    if (checked != null) {
                        ResourceListAndTreeGroup.this.treeViewer.setCheckedElements(checked.toArray());
                    }
                }
            }
        });
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected void createTreeViewer(Composite parent, boolean useHeightHint) {
        Tree tree = new Tree(parent, 2080);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                ModelNode node = (ModelNode)parentElement;
                Object[] versions = node.getVersions();
                return versions;
            }

            public Object getParent(Object element) {
                ModelNode node = (ModelNode)element;
                return node.getParent();
            }

            public boolean hasChildren(Object element) {
                ModelNode node = (ModelNode)element;
                return node.hasChildren();
            }

            public Object[] getElements(Object inputElement) {
                Object[] root = (ModelNode[])inputElement;
                return root;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ModelNode node = (ModelNode)element;
                return node.getFullName();
            }
        });
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected void initialize() {
        this.listViewer.setInput((Object)this.root);
    }

    protected void listItemChecked(ModelNode listElement, boolean state) {
        this.listViewer.setGrayed((Object)listElement, false);
        if (state) {
            HashSet set = (HashSet)this.checkedStateStore.get(listElement.getId());
            if (set == null) {
                set = new HashSet(9);
                this.checkedStateStore.put(listElement.getId(), set);
            }
            this.addAll(set, listElement);
        } else {
            this.checkedStateStore.remove(listElement.getId());
        }
        ModelNode node = (ModelNode)((IStructuredSelection)this.listViewer.getSelection()).getFirstElement();
        if (listElement == node) {
            this.treeViewer.expandAll();
            this.treeViewer.setSubtreeChecked((Object)node, state);
        }
    }

    protected void treeItemChecked(ModelNode listElement, boolean state) {
        HashSet<ModelNode> set = (HashSet<ModelNode>)this.checkedStateStore.get(listElement.getId());
        ModelNode node = this.root.findRootModel(listElement.getId());
        if (state) {
            if (set == null) {
                set = new HashSet<ModelNode>(9);
                this.checkedStateStore.put(listElement.getId(), set);
            }
            set.add(listElement);
            if (set.size() == this.countVersions(node)) {
                this.setChecked(node);
            } else {
                this.setGrayChecked(node);
            }
        } else {
            if (set != null) {
                set.remove(listElement);
                if (set.isEmpty()) {
                    this.checkedStateStore.remove(listElement.getId());
                    set = null;
                }
            }
            if (set == null) {
                this.setUnchecked(node);
            } else {
                this.setGrayChecked(node);
            }
        }
    }

    private void setGrayChecked(ModelNode node) {
        this.listViewer.setChecked((Object)node, true);
        this.listViewer.setGrayed((Object)node, true);
    }

    private void setUnchecked(ModelNode node) {
        this.listViewer.setChecked((Object)node, false);
        this.listViewer.setGrayed((Object)node, false);
    }

    private void setChecked(ModelNode node) {
        this.listViewer.setChecked((Object)node, true);
        this.listViewer.setGrayed((Object)node, false);
    }

    private int countVersions(ModelNode node) {
        int count = 1;
        Object[] versions = node.getVersions();
        int i = 0;
        while (i < versions.length) {
            count += this.countVersions((ModelNode)versions[i]);
            ++i;
        }
        return count;
    }

    private void addAll(Set set, ModelNode node) {
        set.add(node);
        Iterator i = node.publicVersions();
        while (i.hasNext()) {
            this.addAll(set, (ModelNode)i.next());
        }
    }

    protected void notifyCheckStateChangeListeners(final CheckStateChangedEvent event) {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
            ++i;
        }
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setAllSelections(boolean selection) {
        if (this.root == null) {
            return;
        }
        this.listViewer.setAllChecked(selection);
        this.listViewer.setAllGrayed(false);
        Object[] models = this.root.getRootModels();
        int i = 0;
        while (i < models.length) {
            this.listItemChecked((ModelNode)models[i], selection);
            ++i;
        }
    }

    public void setRoot(FileSystemStore newRoot) {
        this.root = newRoot;
        this.initialize();
    }

    public void setFocus() {
        this.listViewer.getTable().setFocus();
    }

    public List getAllCheckedListItems() {
        ArrayList result = new ArrayList();
        for (Set set : this.checkedStateStore.values()) {
            result.addAll(set);
        }
        return result;
    }
}

