/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.convert;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.Direction;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IApplication;
import org.eclipse.stardust.engine.api.model.IConditionalPerformer;
import org.eclipse.stardust.engine.api.model.IDataMapping;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IModelParticipant;
import org.eclipse.stardust.engine.api.model.IOrganization;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.model.IRole;
import org.eclipse.stardust.engine.api.model.ITransition;
import org.eclipse.stardust.engine.api.model.ITrigger;
import org.eclipse.stardust.engine.api.model.ImplementationType;
import org.eclipse.stardust.engine.api.model.Inconsistency;
import org.eclipse.stardust.engine.core.compatibility.diagram.ConnectionSymbol;
import org.eclipse.stardust.engine.core.compatibility.diagram.Diagram;
import org.eclipse.stardust.engine.core.compatibility.diagram.NodeSymbol;
import org.eclipse.stardust.engine.core.compatibility.diagram.Symbol;
import org.eclipse.stardust.engine.core.model.builder.DefaultModelBuilder;
import org.eclipse.stardust.engine.core.model.gui.ActivitySymbol;
import org.eclipse.stardust.engine.core.model.gui.ApplicationSymbol;
import org.eclipse.stardust.engine.core.model.gui.ConditionalPerformerSymbol;
import org.eclipse.stardust.engine.core.model.gui.DataMappingConnection;
import org.eclipse.stardust.engine.core.model.gui.DataSymbol;
import org.eclipse.stardust.engine.core.model.gui.ExecutedByConnection;
import org.eclipse.stardust.engine.core.model.gui.OrganizationSymbol;
import org.eclipse.stardust.engine.core.model.gui.PerformsConnection;
import org.eclipse.stardust.engine.core.model.gui.RoleSymbol;
import org.eclipse.stardust.engine.core.model.gui.TransitionConnection;
import org.eclipse.stardust.engine.core.model.utils.ModelElementList;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.convert.ConvertWarningException;
import org.eclipse.stardust.modeling.modelimport.convert.Indent;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class Converter {
    private static final Logger trace = LogManager.getLogger(Converter.class);
    public static final int PROTOTYPE_MODE = 0;
    public static final int PRODUCTION_MODE = 1;
    protected LinkedList converterWarnings;
    protected IModel model;
    private Indent indent = new Indent();
    private HashMap processData;
    private static final String DATA_X_POS = "DATA_X_POS";
    protected int triggerId;

    public Converter() {
        this.converterWarnings = new LinkedList();
    }

    protected void populateDefaultDiagrams() {
        ModelElementList processes = this.model.getProcessDefinitions();
        for (IProcessDefinition processDefinition : processes) {
            this.processData = new HashMap();
            this.processData.put(DATA_X_POS, new Integer(40));
            try {
                Iterator diagrams;
                ModelElementList activities = processDefinition.getActivities();
                if (activities.isEmpty() || !(diagrams = processDefinition.getAllDiagrams()).hasNext()) continue;
                this.traverseActivityGraph((Diagram)diagrams.next(), processDefinition.getRootActivity(), 0, new ArrayList<Integer>(), new HashMap<String, ActivitySymbol>());
            }
            catch (Exception e) {
                trace.warn((Object)(String.valueOf(Import_Messages.MSG_CouldNotCreateActivityGraphForProcess) + processDefinition.getName() + "(" + processDefinition.getId() + ")"), (Throwable)e);
                ConvertWarningException warning = new ConvertWarningException(String.valueOf(Import_Messages.MSG_CouldNotCreateActivityGraph) + e.getMessage());
                warning.setProcessDefinition(processDefinition);
                this.converterWarnings.addLast(warning);
            }
        }
    }

    private ActivitySymbol traverseActivityGraph(Diagram diagram, IActivity startActivity, int x, ArrayList<Integer> yLevels, HashMap<String, ActivitySymbol> visitedActivities) {
        int X_OFFSET = 40;
        int Y_OFFSET = 160;
        int WIDTH = 300;
        int HEIGHT = 200;
        if (visitedActivities.get(startActivity.getId()) != null) {
            return visitedActivities.get(startActivity.getId());
        }
        if (x >= yLevels.size()) {
            yLevels.add(new Integer(0));
        }
        ActivitySymbol activitySymbol = new ActivitySymbol(startActivity);
        visitedActivities.put(startActivity.getId(), activitySymbol);
        diagram.addToNodes((NodeSymbol)activitySymbol, 0);
        int xPos = X_OFFSET + x * WIDTH;
        int yPos = Y_OFFSET + yLevels.get(x) * HEIGHT;
        activitySymbol.move(xPos, yPos);
        this.createPerformerSymbol(startActivity.getPerformer(), activitySymbol, diagram);
        this.createApplicationSymbol(startActivity.getApplication(), activitySymbol, diagram);
        this.createDataSymbols(startActivity.getAllDataMappings(), activitySymbol, diagram);
        ++x;
        Iterator outTransitions = startActivity.getAllOutTransitions();
        while (outTransitions.hasNext()) {
            ITransition transition = (ITransition)outTransitions.next();
            IActivity nextActivity = transition.getToActivity();
            ActivitySymbol nextActivitySymbol = visitedActivities.get(nextActivity.getId());
            if (nextActivitySymbol == null) {
                nextActivitySymbol = this.traverseActivityGraph(diagram, nextActivity, x, yLevels, visitedActivities);
                yLevels.set(x, new Integer(yLevels.get(x) + 1));
            }
            try {
                TransitionConnection transitionConnection = new TransitionConnection(transition);
                transitionConnection.setFirstSymbol((Symbol)activitySymbol);
                transitionConnection.setSecondSymbol((Symbol)nextActivitySymbol, false);
                diagram.addToConnections((ConnectionSymbol)transitionConnection, 0);
            }
            catch (Throwable e) {
                System.out.println(String.valueOf(Import_Messages.MSG_CreateTransitions) + startActivity.getName() + "-> " + nextActivity.getName() + ": " + e);
            }
        }
        --x;
        return activitySymbol;
    }

    private void createDataSymbols(Iterator dataMappings, ActivitySymbol activitySymbol, Diagram diagram) {
        while (dataMappings.hasNext()) {
            IDataMapping dataMapping = (IDataMapping)dataMappings.next();
            DataSymbol dataSymbol = (DataSymbol)this.processData.get(dataMapping.getData().getId());
            if (dataSymbol == null) {
                int dataXPos = (Integer)this.processData.get(DATA_X_POS);
                dataSymbol = new DataSymbol(dataMapping.getData());
                dataSymbol.move(dataXPos, 20);
                diagram.addToNodes((NodeSymbol)dataSymbol, 0);
                this.processData.put(dataMapping.getData().getId(), dataSymbol);
                dataXPos = dataXPos + dataSymbol.getWidth() + 20;
                this.processData.put(DATA_X_POS, new Integer(dataXPos));
            }
            DataMappingConnection mappingConn = new DataMappingConnection(dataMapping.getData(), dataMapping.getActivity(), dataMapping.getDirection());
            if (dataMapping.getDirection() == Direction.IN) {
                mappingConn.setFirstSymbol((Symbol)dataSymbol);
                mappingConn.setSecondSymbol((Symbol)activitySymbol);
            } else {
                mappingConn.setFirstSymbol((Symbol)activitySymbol);
                mappingConn.setSecondSymbol((Symbol)dataSymbol);
            }
            diagram.addToConnections((ConnectionSymbol)mappingConn, 0);
        }
    }

    private void createApplicationSymbol(IApplication application, ActivitySymbol activitySymbol, Diagram diagram) {
        if (application != null) {
            ApplicationSymbol applicationSymbol = new ApplicationSymbol(application);
            int appX = activitySymbol.getX() + (activitySymbol.getWidth() - applicationSymbol.getWidth()) / 2;
            int appY = activitySymbol.getY() + 70;
            applicationSymbol.move(appX, appY);
            diagram.addToNodes((NodeSymbol)applicationSymbol, 0);
            ExecutedByConnection exCon = new ExecutedByConnection(applicationSymbol);
            exCon.setSecondSymbol((Symbol)activitySymbol, false);
            diagram.addToConnections((ConnectionSymbol)exCon, 0);
        }
    }

    private void createPerformerSymbol(IModelParticipant performer, ActivitySymbol activitySymbol, Diagram diagram) {
        RoleSymbol performerSymbol = null;
        PerformsConnection performsConn = null;
        if (performer instanceof IRole) {
            performerSymbol = new RoleSymbol((IRole)performer);
            performsConn = new PerformsConnection(performerSymbol);
        } else if (performer instanceof IOrganization) {
            performerSymbol = new OrganizationSymbol((IOrganization)performer);
            performsConn = new PerformsConnection((OrganizationSymbol)performerSymbol);
        } else if (performer instanceof IConditionalPerformer) {
            performerSymbol = new ConditionalPerformerSymbol((IConditionalPerformer)performer);
            performsConn = new PerformsConnection((ConditionalPerformerSymbol)performerSymbol);
        }
        if (performerSymbol != null) {
            int perfX = activitySymbol.getX() + (activitySymbol.getWidth() - performerSymbol.getWidth()) / 2;
            int perfY = activitySymbol.getY() - 70;
            performerSymbol.move(perfX, perfY);
            diagram.addToNodes((NodeSymbol)performerSymbol, 0);
            performsConn.setSecondSymbol((Symbol)activitySymbol);
            diagram.addToConnections((ConnectionSymbol)performsConn, 0);
        }
    }

    protected String getIndent() {
        return this.indent.toString();
    }

    protected void incIndent() {
        this.indent.inc();
    }

    protected void decIndent() {
        this.indent.dec();
    }

    protected void adjustForExecutability() {
        IModelParticipant administrator = this.model.findParticipant("Administrator");
        Iterator processDefinitions = this.model.getAllProcessDefinitions();
        while (processDefinitions.hasNext()) {
            IProcessDefinition processDefinition = (IProcessDefinition)processDefinitions.next();
            if (!processDefinition.getAllTriggers().hasNext()) {
                String id = "trigger" + ++this.triggerId;
                String name = id.toUpperCase();
                ITrigger trigger = processDefinition.createTrigger(id, name, this.model.findTriggerType("manual"), 0);
                trigger.setAttribute("carnot:engine:participant", (Object)administrator.getId());
            }
            Iterator activities = processDefinition.getAllActivities();
            while (activities.hasNext()) {
                IActivity activity = (IActivity)activities.next();
                if (activity.getImplementationType().equals((Object)ImplementationType.Manual) && activity.getPerformer() == null) {
                    activity.setPerformer(administrator);
                    continue;
                }
                if (!activity.getImplementationType().equals((Object)ImplementationType.Application)) continue;
                if (activity.getApplication().isInteractive() && activity.getPerformer() == null) {
                    activity.setImplementationType(ImplementationType.Manual);
                    activity.setApplication(null);
                    activity.setPerformer(administrator);
                    continue;
                }
                activity.setImplementationType(ImplementationType.Route);
                activity.setApplication(null);
            }
        }
    }

    protected Document getDocumentFromInputStream(InputStream inputStream) {
        Document document;
        Assert.isNotNull((Object)inputStream, (String)MessageFormat.format(Import_Messages.MSG_CannotCreateDocFromNull, null));
        try {
            DocumentBuilder domBuilder = XmlUtils.newDomBuilder();
            document = domBuilder.parse(new InputSource(inputStream));
        }
        catch (Exception e) {
            throw new InternalException(Import_Messages.MSG_CouldNotCreateFromInputStream, (Throwable)e);
        }
        return document;
    }

    protected IModel createModel() {
        return DefaultModelBuilder.create().createModel("name", "name", "description");
    }

    public Vector getInconsistencies() {
        Vector<Inconsistency> inconsistencies = new Vector<Inconsistency>();
        for (ConvertWarningException warning : this.converterWarnings) {
            String message = "Process " + warning.getProcessDefinition().getName() + ": " + warning.getMessage();
            Inconsistency inconsistency = new Inconsistency(message, warning.getProcessDefinition().getElementOID(), 0);
            inconsistencies.addElement(inconsistency);
        }
        return inconsistencies;
    }
}

