/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.convert;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    private static final Logger trace = LogManager.getLogger(XMLUtil.class);

    public static Node getChildByName(Node parent, String name) {
        try {
            NodeList childdren = parent.getChildNodes();
            int i = 0;
            while (i < childdren.getLength()) {
                if (name.equals(childdren.item(i).getNodeName())) {
                    return childdren.item(i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            trace.warn((Object)MessageFormat.format(Import_Messages.MSG_ErrRetrievingChild, name, parent), (Throwable)e);
        }
        return null;
    }

    public static List<Node> getChildrenByName(Node parent, String name) {
        List retVal = CollectionUtils.newList();
        try {
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (name.equals(children.item(i).getNodeName())) {
                    retVal.add(children.item(i));
                }
                ++i;
            }
        }
        catch (Exception e) {
            trace.warn((Object)MessageFormat.format(Import_Messages.MSG_ErrRetrievingChild, name, parent), (Throwable)e);
        }
        return retVal;
    }

    public static String getNamedAttribute(Node node, String attributeName) {
        String name = null;
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            if (attributes.item(i).getNodeName() != null && attributes.item(i).getNodeName().equals(attributeName)) {
                name = attributes.item(i).getNodeValue();
            }
            ++i;
        }
        return name;
    }

    public static List<Element> getElementsByName(Node node, String name) {
        List elements = CollectionUtils.newList();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && name.equals(child.getNodeName())) {
                elements.add((Element)child);
            }
            ++i;
        }
        return elements;
    }
}

