/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.elements;

import java.util.List;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.common.CollectionUtils;

public class DifferencesContentProvider
implements ITreeContentProvider {
    private Viewer viewer;
    private Object input;
    protected boolean allFilter = true;
    protected boolean additionFilter = false;
    protected boolean deletionFilter = false;
    protected boolean changeFilter = false;

    public void setAllFilter() {
        this.allFilter = true;
        this.additionFilter = false;
        this.deletionFilter = false;
        this.changeFilter = false;
    }

    public void setAdditionFilter() {
        this.allFilter = false;
        this.additionFilter = true;
        this.deletionFilter = false;
        this.changeFilter = false;
    }

    public void setDeletionFilter() {
        this.allFilter = false;
        this.additionFilter = false;
        this.deletionFilter = true;
        this.changeFilter = false;
    }

    public void setChangeFilter() {
        this.allFilter = false;
        this.additionFilter = false;
        this.deletionFilter = false;
        this.changeFilter = true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        this.input = newInput;
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    public void dispose() {
        this.inputChanged(this.viewer, this.input, null);
    }

    public Object getParent(Object element) {
        if (element instanceof IDiffElement) {
            return ((IDiffElement)element).getParent();
        }
        return null;
    }

    public final boolean hasChildren(Object element) {
        if (element instanceof IDiffContainer) {
            return ((IDiffContainer)element).hasChildren();
        }
        return false;
    }

    public final Object[] getChildren(Object element) {
        if (this.allFilter) {
            if (element instanceof IDiffContainer) {
                return ((IDiffContainer)element).getChildren();
            }
            return new Object[0];
        }
        if (element instanceof IDiffContainer) {
            int kind = this.additionFilter ? 2 : (this.deletionFilter ? 1 : 3);
            List filteredChildren = CollectionUtils.newList();
            IDiffElement[] children = ((IDiffContainer)element).getChildren();
            int i = 0;
            while (i < children.length) {
                if (this.matchesFilters(children[i], kind)) {
                    filteredChildren.add(children[i]);
                }
                ++i;
            }
            return filteredChildren.toArray();
        }
        return new Object[0];
    }

    private boolean matchesFilters(IDiffElement diff, int kind) {
        if (diff instanceof IDiffContainer && ((IDiffContainer)diff).hasChildren()) {
            IDiffElement[] children = ((IDiffContainer)diff).getChildren();
            int i = 0;
            while (i < children.length) {
                if (this.matchesFilters(children[i], kind)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return diff.getKind() == kind;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }
}

