/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.elements;

import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.elements.DifferencesContentProvider;
import org.eclipse.stardust.modeling.modelimport.elements.MergeEditorInput;
import org.eclipse.stardust.modeling.modelimport.elements.MergeUtil;
import org.eclipse.stardust.modeling.modelimport.elements.ModelElementsSorter;
import org.eclipse.swt.widgets.Composite;

public final class DifferencesViewer
extends StructureDiffViewer {
    private static final String MERGE_CATEGORY = "merge";
    private static final String NAVIGATION_CATEGORY = "navigation";
    private static final String FILTER_CATEGORY = "filter";
    private static final String ICONS_FULL_OBJ16_PATH = "/icons/full/obj16/";
    private static final IPath ICONS_PATH = new Path("icons/full/");
    private Action additionFilterAction;
    private Action deletionFilterAction;
    private Action changeFilterAction;
    private Action allFilterAction;
    private DifferencesContentProvider contentProvider = new DifferencesContentProvider();
    private IStructureCreator creator = new IStructureCreator(){

        public String getContents(Object node, boolean ignoreWhitespace) {
            return ((ITypedElement)node).getName();
        }

        public String getName() {
            return Import_Messages.DifferencesViewer_Title;
        }

        public IStructureComparator getStructure(Object input) {
            return (IStructureComparator)input;
        }

        public IStructureComparator locate(Object path, Object input) {
            return null;
        }

        public void save(IStructureComparator node, Object input) {
            DifferencesViewer.this.input.setDirty(true);
        }
    };
    private MergeEditorInput input;
    private List<ICompareInput> processed = CollectionUtils.newList();

    public DifferencesViewer(Composite parent, MergeEditorInput input, CompareConfiguration configuration) {
        super(parent, configuration);
        this.setContentProvider((IContentProvider)this.contentProvider);
        this.setStructureCreator(this.creator);
        this.setSorter(new ModelElementsSorter());
        this.input = input;
    }

    protected void copySelected(boolean leftToRight) {
        super.copySelected(leftToRight);
        MergeUtil.copyReferences();
        this.processed.clear();
        this.setSelection(null);
        this.contentChanged(null);
        this.input.contentChanged();
    }

    protected void copyOne(ICompareInput node, boolean leftToRight) {
        int i = 0;
        while (i < this.processed.size()) {
            if (this.processed.get(i) == node) {
                return;
            }
            ++i;
        }
        if (node instanceof IDiffContainer && ((IDiffContainer)node).hasChildren()) {
            Object[] children = this.contentProvider.getChildren(node);
            int i2 = 0;
            while (i2 < children.length) {
                if (children[i2] instanceof ICompareInput) {
                    this.copyOne((ICompareInput)children[i2], leftToRight);
                }
                ++i2;
            }
        } else {
            node.copy(leftToRight);
        }
        this.processed.add(node);
    }

    public void initAction(IAction a, ResourceBundle bundle, String prefix) {
        String label;
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        a.setText((label = this.getString(bundle, labelKey)) == null ? labelKey : label);
        a.setToolTipText(this.getString(bundle, tooltipKey));
        a.setDescription(this.getString(bundle, descriptionKey));
        String relPath = this.getString(bundle, imageKey);
        if (relPath != null && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.indexOf("/") >= 0) {
                String path = relPath.substring(1);
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = this.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = this.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
                a.setHoverImageDescriptor(id);
            }
        }
    }

    private String getString(ResourceBundle bundle, String labelKey) {
        try {
            return bundle.getString(labelKey);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ImageDescriptor getImageDescriptor(String dPath) {
        String name = ICONS_PATH.append(dPath).toString();
        URL url = CompareUI.getPlugin().getBundle().getEntry(name);
        return url == null ? null : ImageDescriptor.createFromURL((URL)url);
    }

    protected void createToolItems(ToolBarManager toolbarManager) {
        Action copyLeftToRightAction = new Action(){

            public void run() {
                DifferencesViewer.this.copySelected(true);
            }
        };
        this.initAction((IAction)copyLeftToRightAction, this.getBundle(), "action.TakeLeft.");
        toolbarManager.appendToGroup(MERGE_CATEGORY, (IAction)copyLeftToRightAction);
        Action nextAction = new Action(){

            public void run() {
                DifferencesViewer.this.navigate(true);
            }
        };
        this.initAction((IAction)nextAction, this.getBundle(), "action.NextDiff.");
        toolbarManager.appendToGroup(NAVIGATION_CATEGORY, (IAction)nextAction);
        Action previousAction = new Action(){

            public void run() {
                DifferencesViewer.this.navigate(false);
            }
        };
        this.initAction((IAction)previousAction, this.getBundle(), "action.PrevDiff.");
        toolbarManager.appendToGroup(NAVIGATION_CATEGORY, (IAction)previousAction);
        toolbarManager.add((IContributionItem)new Separator(FILTER_CATEGORY));
        this.allFilterAction = new Action("all", 8){

            public void run() {
                DifferencesViewer.this.contentProvider.setAllFilter();
                DifferencesViewer.this.refresh();
            }
        };
        this.allFilterAction.setText(Import_Messages.DifferencesViewer_allFilterActionText);
        this.allFilterAction.setToolTipText(Import_Messages.DifferencesViewer_allFilterActionTooltip);
        this.allFilterAction.setImageDescriptor(DiagramPlugin.getImageDescriptor((String)"/icons/full/obj16/all_changes.gif"));
        toolbarManager.appendToGroup(FILTER_CATEGORY, (IAction)this.allFilterAction);
        this.allFilterAction.setChecked(true);
        this.additionFilterAction = new Action("addition", 8){

            public void run() {
                DifferencesViewer.this.contentProvider.setAdditionFilter();
                DifferencesViewer.this.refresh();
            }
        };
        this.additionFilterAction.setText(Import_Messages.DifferencesViewer_additionFilterText);
        this.additionFilterAction.setToolTipText(Import_Messages.DifferencesViewer_additionFilterTooltip);
        this.additionFilterAction.setImageDescriptor(DiagramPlugin.getImageDescriptor((String)"/icons/full/obj16/additive_changes.gif"));
        toolbarManager.appendToGroup(FILTER_CATEGORY, (IAction)this.additionFilterAction);
        this.deletionFilterAction = new Action("deletion", 8){

            public void run() {
                DifferencesViewer.this.contentProvider.setDeletionFilter();
                DifferencesViewer.this.refresh();
            }
        };
        this.deletionFilterAction.setText(Import_Messages.DifferencesViewer_deletionFilterText);
        this.deletionFilterAction.setToolTipText(Import_Messages.DifferencesViewer_deletionFilterTooltip);
        this.deletionFilterAction.setImageDescriptor(DiagramPlugin.getImageDescriptor((String)"/icons/full/obj16/subtractive_changes.gif"));
        toolbarManager.appendToGroup(FILTER_CATEGORY, (IAction)this.deletionFilterAction);
        this.changeFilterAction = new Action("change", 8){

            public void run() {
                DifferencesViewer.this.contentProvider.setChangeFilter();
                DifferencesViewer.this.refresh();
            }
        };
        this.changeFilterAction.setText(Import_Messages.DifferencesViewer_changedFilterText);
        this.changeFilterAction.setToolTipText(Import_Messages.DifferencesViewer_changedFilterToolTip);
        this.changeFilterAction.setImageDescriptor(DiagramPlugin.getImageDescriptor((String)"/icons/full/obj16/update_changes.gif"));
        toolbarManager.appendToGroup(FILTER_CATEGORY, (IAction)this.changeFilterAction);
    }
}

