/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.elements;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.modelimport.IImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.ImportPlugin;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.elements.ContentCompareViewer;
import org.eclipse.stardust.modeling.modelimport.elements.DifferencesViewer;
import org.eclipse.stardust.modeling.modelimport.elements.MergeUtil;
import org.eclipse.stardust.modeling.modelimport.elements.Root;
import org.eclipse.stardust.modeling.modelimport.elements.RootComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class MergeEditorInput
extends CompareEditorInput {
    private WorkflowModelManager source;
    private WorkflowModelManager target;
    private boolean dirty = false;
    private DifferencesViewer diffViewer;
    private IImportModelWizardPage page;
    private Viewer cmpViewer;
    private String sourceName;

    public MergeEditorInput(IImportModelWizardPage page) {
        super(new CompareConfiguration());
        this.page = page;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.beginTask(Import_Messages.MergeEditorInput_OpenCompareViewerTaskName, 4);
        MergeEditorInput.load(monitor, this.source, this.sourceName);
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.worked(1);
        Root sourceRoot = new Root(this.source);
        Root targetRoot = new Root(this.target);
        boolean returnCode = false;
        final RootComparator nodeOne = new RootComparator(sourceRoot);
        final RootComparator nodeTwo = new RootComparator(targetRoot);
        new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MergeEditorInput.this.initializeCompareConfiguration(nodeOne, nodeTwo);
                return Status.OK_STATUS;
            }
        }.schedule();
        monitor.subTask(Import_Messages.MergeEditorInput_CheckingDuplicateOidsTaskName);
        try {
            this.source.getModelOidUtil().setEnabled(false);
            returnCode = MergeUtil.initialize(sourceRoot.getModel(), targetRoot.getModel(), this);
        }
        finally {
            this.source.getModelOidUtil().setEnabled(true);
        }
        if (returnCode) {
            monitor.setCanceled(true);
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.worked(1);
        monitor.subTask(Import_Messages.MergeEditorInput_ComparingTaskName);
        Differencer differencer = new Differencer();
        Object input = differencer.findDifferences(false, null, null, null, (Object)nodeOne, (Object)nodeTwo);
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.worked(1);
        return input;
    }

    private void initializeCompareConfiguration(ITypedElement one, ITypedElement two) {
        CompareConfiguration config = this.getCompareConfiguration();
        config.setRightEditable(false);
        config.setLeftEditable(false);
        config.setLeftLabel(one.getName());
        config.setLeftImage(one.getImage());
        config.setRightLabel(two.getName());
        config.setRightImage(two.getImage());
    }

    public static void load(IProgressMonitor monitor, WorkflowModelManager resource, String name) throws InvocationTargetException {
        monitor.subTask(MessageFormat.format(Import_Messages.MergeEditorInput_LoadingTaskName, name));
        try {
            resource.load(null);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void setSource(WorkflowModelManager source) {
        this.source = source;
        this.sourceName = source.toString();
    }

    public void setTarget(WorkflowModelManager target) {
        this.target = target;
    }

    public DifferencesViewer getDiffViewer() {
        return this.diffViewer;
    }

    public Viewer createDiffViewer(Composite parent) {
        this.diffViewer = new DifferencesViewer(parent, this, this.getCompareConfiguration());
        return this.diffViewer;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        this.cmpViewer = oldViewer instanceof ContentCompareViewer ? oldViewer : new ContentCompareViewer(parent, this.getCompareConfiguration());
        return this.cmpViewer;
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        try {
            this.target.save(this.target.getModel().eResource().getURI());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String uri = this.target.getModel().eResource().getURI().path();
            if (uri.startsWith("/resource")) {
                uri = uri.substring("/resource".length());
            }
            final IFile file = (IFile)root.findMember((IPath)new Path(uri));
            IWorkbenchPage workbenchPage = ImportPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] references = workbenchPage.getEditorReferences();
            int i = 0;
            while (i < references.length) {
                ModelType model;
                IEditorPart editor = references[i].getEditor(true);
                if (editor instanceof WorkflowModelEditor && (model = ((WorkflowModelEditor)editor).getWorkflowModel()) != null && CompareHelper.areEqual((Object)this.target.getModel().eResource().getURI(), (Object)model.eResource().getURI())) {
                    workbenchPage.closeEditor(editor, false);
                }
                ++i;
            }
            new WorkbenchJob(Import_Messages.MergeEditorInput_OpenEditorJobName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IWorkbenchPage page = ImportPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException e) {
                        return new Status(2, "org.eclipse.stardust.modeling.modelimport", 0, e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.modelimport", 0, e.getMessage(), (Throwable)e));
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.page.updateButtons();
    }

    public void contentChanged() {
        if (this.cmpViewer != null) {
            this.cmpViewer.refresh();
        }
    }

    public boolean showErrors(final String[] errors) {
        final boolean[] result = new boolean[1];
        ((WizardPage)this.page).getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                StringBuffer message = new StringBuffer();
                message.append(Import_Messages.MergeEditorInput_ERROR_MESSAGE_HEADLINE);
                int i = 0;
                while (i < errors.length) {
                    message.append("\n  - ").append(errors[i]).append(';');
                    ++i;
                }
                message.append(Import_Messages.MergeEditorInput_ERROR_MESSAGE_NEWOIDS);
                message.append(Import_Messages.MergeEditorInput_ERROR_MESSAGE_CONTINUE);
                result[0] = MessageDialog.openQuestion((Shell)((WizardPage)MergeEditorInput.this.page).getShell(), (String)Import_Messages.MergeEditorInput_ERROR_MESSAGE_TITLE, (String)message.toString());
            }
        });
        return result[0];
    }
}

