/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.elements;

import java.awt.Dimension;
import java.awt.Toolkit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.modelimport.IImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.elements.ImportModelElementsWizardPage;
import org.eclipse.stardust.modeling.modelimport.elements.MergeEditorInput;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class MergeModelElementsWizardPage
extends WizardPage
implements IImportModelWizardPage {
    private static final String IMG_WIZBAN_IMPORT_WIZ = "IMG_WIZBAN_IMPORT_WIZ";
    private ImportModelElementsWizardPage sourcePage;
    private MergeEditorInput input;
    private Composite composite;

    protected MergeModelElementsWizardPage(String pageName, ImportModelElementsWizardPage sourcePage) {
        super(pageName);
        this.setTitle(Import_Messages.MergeModelElementsWizardPage_Title);
        this.setDescription(Import_Messages.MergeModelElementsWizardPage_Comment);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor(IMG_WIZBAN_IMPORT_WIZ));
        this.sourcePage = sourcePage;
    }

    @Override
    public IProject getProjectContext() {
        return this.sourcePage.getProjectContext();
    }

    @Override
    public IDialogSettings getWizardSettings() {
        return this.getDialogSettings();
    }

    @Override
    public boolean performFinish() {
        boolean result = true;
        try {
            this.input.saveChanges(null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Import_Messages.MergeModelElementsWizardPage_ERROR_DIALOG_TITLE, (String)e.getMessage(), (IStatus)e.getStatus());
            result = false;
        }
        return result;
    }

    @Override
    public void updateButtons() {
        this.getWizard().getContainer().updateButtons();
    }

    public void createControl(Composite parent) {
        this.composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.setControl((Control)this.composite);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("ShowViewDialog");
        Point loc = null;
        Point size = null;
        if (wizardSettings == null) {
            loc = this.getShell().getLocation();
            size = this.getShell().getSize();
        } else {
            int height = wizardSettings.getInt("DIALOG_HEIGHT");
            int width = wizardSettings.getInt("DIALOG_WIDTH");
            size = new Point(width * 2, height * 2);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            loc = new Point(new Integer((int)dim.getWidth()).intValue(), new Integer((int)dim.getHeight()).intValue());
            loc.x -= size.x;
            loc.y -= size.y;
            loc.x /= 2;
            loc.y /= 2;
        }
        this.getShell().setLocation(loc);
        this.getShell().setSize(size);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            boolean isNew = this.input == null;
            this.input = this.sourcePage.getInput();
            if (isNew) {
                Control control = this.input.createContents(this.composite);
                GridData gd = new GridData(1808);
                control.setLayoutData((Object)gd);
                this.composite.layout(true, true);
            } else {
                this.input.getDiffViewer().setInput(this.input.getCompareResult());
                this.input.contentChanged();
            }
        }
        super.setVisible(visible);
    }

    public boolean isPageComplete() {
        return this.input != null && this.input.isDirty();
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = super.canFlipToNextPage();
        if (this.input != null && this.input.getCompareResult() == null && this.input.getDiffViewer() == null) {
            WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            Shell shell = editor.getSite().getShell();
            MessageDialog.openInformation((Shell)shell, (String)Import_Messages.MergeModelElementsWizardPage_InfoDialogTitle, (String)Import_Messages.MergeModelElementsWizardPage_InfoDialogText);
        }
        return canFlip;
    }
}

