/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.effort;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.modeling.project.effort.EffortEvent;
import org.eclipse.stardust.modeling.project.effort.EffortKey;
import org.eclipse.stardust.modeling.project.effort.EffortParameter;
import org.eclipse.stardust.modeling.project.effort.EffortParameterScope;
import org.eclipse.stardust.modeling.project.effort.NamedItemList;

public class EffortByKeyParameter
extends NamedItemList
implements EffortParameter {
    private String name;
    private EffortParameterScope scope;

    public EffortByKeyParameter(EffortParameterScope scope, String name, String initializers) {
        this(scope, name);
        String[] keyDefinitions = initializers.split(",");
        int n = 0;
        while (n < keyDefinitions.length) {
            String[] keyDefinition = keyDefinitions[n].trim().split("=");
            this.add(new EffortKey(this, keyDefinition[0].trim(), keyDefinition[1].trim()));
            ++n;
        }
    }

    public EffortByKeyParameter(EffortParameterScope scope, String name, String[] keyNames, double[] efforts) {
        this(scope, name);
        int i = 0;
        while (i < efforts.length) {
            this.add(new EffortKey(this, keyNames[i], efforts[i]));
            ++i;
        }
    }

    private EffortByKeyParameter(EffortParameterScope scope, String name) {
        this.scope = scope;
        this.name = name;
    }

    @Override
    public EffortParameterScope getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        if (!CompareHelper.areEqual((Object)name, (Object)oldName)) {
            this.name = name;
            this.scope.getEffortParameters().markModified();
            this.scope.getEffortParameters().parameterNameChanged(this, name, oldName);
            this.notifyListeners(new EffortEvent(this, "name", name, oldName));
        }
    }

    public void addKey(EffortKey key) {
        this.add(key);
        this.scope.getEffortParameters().markModified();
    }

    public void removeKey(EffortKey key) {
        this.remove(key);
        this.scope.getEffortParameters().markModified();
    }

    public EffortKey getKey(String keyName) {
        return (EffortKey)this.get(keyName);
    }

    public Iterator<String> getKeyNames() {
        return this.getNames();
    }

    @Override
    public double[] calculateEffort(String keyName) {
        EffortKey key = this.getKey(keyName);
        if (key != null) {
            return key.getEffortPerUnit().getEffort();
        }
        throw new IllegalArgumentException(MessageFormat.format("Unknown key {0}.", keyName));
    }

    @Override
    public String getType() {
        return "ByKeyParameter";
    }

    @Override
    public String getInitializers() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            EffortKey key = (EffortKey)this.get(i);
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(key.getName());
            buffer.append('=');
            buffer.append(key.getInitializer());
            ++i;
        }
        return buffer.toString();
    }

    public int keyCount() {
        return this.size();
    }

    public String toString() {
        return this.getName();
    }
}

