/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.effort;

import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.modeling.project.effort.EffortByKeyParameter;
import org.eclipse.stardust.modeling.project.effort.EffortEvent;
import org.eclipse.stardust.modeling.project.effort.EffortNotifier;
import org.eclipse.stardust.modeling.project.effort.EffortParameterScope;
import org.eclipse.stardust.modeling.project.effort.EffortPerUnit;
import org.eclipse.stardust.modeling.project.effort.NamedItem;
import org.eclipse.stardust.modeling.project.effort.ScopedItem;

public class EffortKey
extends EffortNotifier
implements NamedItem,
ScopedItem {
    private EffortByKeyParameter parameter;
    private String name;
    private EffortPerUnit effortPerUnit;

    public EffortKey(EffortByKeyParameter parameter, String name, double value) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter may not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null.");
        }
        this.parameter = parameter;
        this.name = name;
        this.effortPerUnit = new EffortPerUnit((ScopedItem)this, value);
    }

    public EffortKey(EffortByKeyParameter parameter, String name, String initializer) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter may not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null.");
        }
        this.parameter = parameter;
        this.name = name;
        this.effortPerUnit = new EffortPerUnit((ScopedItem)this, initializer);
    }

    public EffortByKeyParameter getParameter() {
        return this.parameter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        if (!CompareHelper.areEqual((Object)name, (Object)oldName)) {
            this.name = name;
            this.parameter.getScope().getEffortParameters().markModified();
            this.parameter.getScope().getEffortParameters().keyNameChanged(this, name, oldName);
            this.notifyListeners(new EffortEvent(this, "name", name, oldName));
        }
    }

    public EffortPerUnit getEffortPerUnit() {
        return this.effortPerUnit;
    }

    public String getInitializer() {
        return this.effortPerUnit.getInitializer();
    }

    @Override
    public EffortParameterScope getScope() {
        return this.parameter.getScope();
    }
}

