/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.effort;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IAttributeCategory;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.project.Project_Messages;
import org.eclipse.stardust.modeling.project.effort.EffortByKeyParameter;
import org.eclipse.stardust.modeling.project.effort.EffortByQuantityParameter;
import org.eclipse.stardust.modeling.project.effort.EffortEvent;
import org.eclipse.stardust.modeling.project.effort.EffortKey;
import org.eclipse.stardust.modeling.project.effort.EffortNotifier;
import org.eclipse.stardust.modeling.project.effort.EffortParameter;
import org.eclipse.stardust.modeling.project.effort.EffortParameterScope;

public class EffortParameters
extends EffortNotifier {
    private ModelType model;
    public final EffortParameterScope MODEL_SCOPE = new EffortParameterScope(this, ModelType.class, null);
    public final EffortParameterScope PROCESS_SCOPE = new EffortParameterScope(this, ProcessDefinitionType.class, null);
    public final EffortParameterScope ACTIVITY_SCOPE = new EffortParameterScope(this, ActivityType.class, null);
    public final EffortParameterScope TRANSITION_SCOPE = new EffortParameterScope(this, TransitionType.class, null);
    public final EffortParameterScope DATA_SCOPE = new EffortParameterScope(this, DataType.class, null);
    public final EffortParameterScope ROLE_SCOPE = new EffortParameterScope(this, RoleType.class, null);
    public final EffortParameterScope ORGANIZATION_SCOPE = new EffortParameterScope(this, OrganizationType.class, null);
    public final EffortParameterScope CONDITIONAL_PERFORMER_SCOPE = new EffortParameterScope(this, ConditionalPerformerType.class, null);
    public final EffortParameterScope INTERACTIVE_APPLICATION_SCOPE = new EffortParameterScope(this, ApplicationType.class, "Interactive");
    public final EffortParameterScope NON_INTERACTIVE_APPLICATION_SCOPE = new EffortParameterScope(this, ApplicationType.class, "Service");
    private final EffortParameterScope[] SCOPES = new EffortParameterScope[]{this.MODEL_SCOPE, this.PROCESS_SCOPE, this.ACTIVITY_SCOPE, this.TRANSITION_SCOPE, this.DATA_SCOPE, this.ROLE_SCOPE, this.ORGANIZATION_SCOPE, this.CONDITIONAL_PERFORMER_SCOPE, this.INTERACTIVE_APPLICATION_SCOPE, this.NON_INTERACTIVE_APPLICATION_SCOPE};
    public final List<EffortParameterScope> SCOPE_LIST = Collections.unmodifiableList(Arrays.asList(this.SCOPES));
    private boolean modified = false;
    private boolean loading;
    public static final String SEPARATOR = ":";

    public EffortParameterScope getScope(Class<?> scope, String filter) {
        int i = 0;
        while (i < this.SCOPES.length) {
            if (this.SCOPES[i].isApplicable(scope, filter)) {
                return this.SCOPES[i];
            }
            ++i;
        }
        return null;
    }

    public static EffortParameters getEffortParameters(ModelType model) {
        if (model == null) {
            return null;
        }
        for (Adapter adapter : model.eAdapters()) {
            if (!(adapter instanceof EffortParameters)) continue;
            return (EffortParameters)adapter;
        }
        return new EffortParameters(model);
    }

    private EffortParameters(ModelType model) {
        this.model = model;
        this.loadFromModel();
        model.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeature() == CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute()) {
                    boolean needsRefresh;
                    boolean bl = needsRefresh = AttributeUtil.getAttribute((IExtensibleElement)EffortParameters.this.model, (String)"project-planning:notifier") == null;
                    if (EffortParameters.this.modified && needsRefresh) {
                        EffortParameters.this.loadFromModel();
                    }
                }
            }
        });
    }

    public void initializeDefaults() {
        this.MODEL_SCOPE.addParameter(new EffortByKeyParameter(this.MODEL_SCOPE, Project_Messages.getString("EffortParameters.ApplicationServerParameter"), new String[]{Project_Messages.getString("EffortParameters.WeblogicKey"), Project_Messages.getString("EffortParameters.WebSphereKey"), Project_Messages.getString("EffortParameters.JBossKey"), Project_Messages.getString("EffortParameters.NetWeaverKey")}, new double[]{1.0, 1.0, 1.0, 1.0}));
        this.MODEL_SCOPE.addParameter(new EffortByKeyParameter(this.MODEL_SCOPE, Project_Messages.getString("EffortParameters.DBMSParameter"), new String[]{Project_Messages.getString("EffortParameters.OracleKey"), Project_Messages.getString("EffortParameters.SqlServerKey"), Project_Messages.getString("EffortParameters.MySqlKey")}, new double[]{1.0, 1.0, 1.0}));
        this.MODEL_SCOPE.addParameter(new EffortByKeyParameter(this.MODEL_SCOPE, Project_Messages.getString("EffortParameters.DirectoryServiceParameter"), new String[]{Project_Messages.getString("EffortParameters.LDAPKey"), Project_Messages.getString("EffortParameters.ActiveDirectoryKey")}, new double[]{1.0, 1.0}));
        this.MODEL_SCOPE.addParameter(new EffortByKeyParameter(this.MODEL_SCOPE, Project_Messages.getString("EffortParameters.PortalTechnologyParameter"), new String[]{Project_Messages.getString("EffortParameters.SWTKey"), Project_Messages.getString("EffortParameters.SwingKey"), Project_Messages.getString("EffortParameters.JSFKey"), Project_Messages.getString("EffortParameters.JSPKey"), Project_Messages.getString("EffortParameters.DotNetKey"), Project_Messages.getString("EffortParameters.OtherPortalKey")}, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}));
        this.MODEL_SCOPE.addParameter(new EffortByQuantityParameter(this.MODEL_SCOPE, Project_Messages.getString("EffortParameters.HighComplexityReportsParameter"), 1.0));
        this.MODEL_SCOPE.addParameter(new EffortByQuantityParameter(this.MODEL_SCOPE, Project_Messages.getString("EffortParameters.MediumComplexityReportsParameter"), 1.0));
        this.MODEL_SCOPE.addParameter(new EffortByQuantityParameter(this.MODEL_SCOPE, Project_Messages.getString("EffortParameters.LowComplexityReportsParameter"), 1.0));
        this.PROCESS_SCOPE.addParameter(new EffortByKeyParameter(this.PROCESS_SCOPE, Project_Messages.getString("EffortParameters.RemainingModelingComplexityParameter"), new String[]{Project_Messages.getString("EffortParameters.WellDefinedKey"), Project_Messages.getString("EffortParameters.ComplexKey"), Project_Messages.getString("EffortParameters.MediumKey"), Project_Messages.getString("EffortParameters.SimpleKey")}, new double[]{1.0, 1.0, 1.0, 1.0}));
        this.ACTIVITY_SCOPE.addParameter(new EffortByKeyParameter(this.ACTIVITY_SCOPE, Project_Messages.getString("EffortParameters.SubprocessRefinementParameter"), new String[]{Project_Messages.getString("EffortParameters.NoRefinementKey"), Project_Messages.getString("EffortParameters.HighComplexityRefinementKey"), Project_Messages.getString("EffortParameters.MediumComplexityRefinementKey"), Project_Messages.getString("EffortParameters.LowComplexityRefinementKey")}, new double[]{0.0, 3.0, 2.0, 1.0}));
        this.TRANSITION_SCOPE.addParameter(new EffortByKeyParameter(this.TRANSITION_SCOPE, Project_Messages.getString("EffortParameters.TransitionTypeParameter"), new String[]{Project_Messages.getString("EffortParameters.ExpressionOnProcessDataKey"), Project_Messages.getString("EffortParameters.ComplexOrAuxillaryLogicKey")}, new double[]{1.0, 1.0}));
        this.TRANSITION_SCOPE.addParameter(new EffortByKeyParameter(this.TRANSITION_SCOPE, Project_Messages.getString("EffortParameters.TransitionComplexityParameter"), new String[]{Project_Messages.getString("EffortParameters.HighKey"), Project_Messages.getString("EffortParameters.MediumKey"), Project_Messages.getString("EffortParameters.LowKey")}, new double[]{1.0, 1.0, 1.0}));
        List<String> dataTechnologies = this.collectDataTechnologies();
        dataTechnologies.add(Project_Messages.getString("EffortParameters.NewDevelopmentKey"));
        this.DATA_SCOPE.addParameter(new EffortByKeyParameter(this.DATA_SCOPE, Project_Messages.getString("EffortParameters.DataTechnologyParameter"), dataTechnologies.toArray(new String[dataTechnologies.size()]), this.createDoubleArray(dataTechnologies.size(), 1.0)));
        this.DATA_SCOPE.addParameter(new EffortByKeyParameter(this.DATA_SCOPE, Project_Messages.getString("EffortParameters.DataDevelopmentParameter"), new String[]{Project_Messages.getString("EffortParameters.LinkToDBMSKey"), Project_Messages.getString("EffortParameters.LinkToOtherKey"), Project_Messages.getString("EffortParameters.NewDataModelKey")}, new double[]{1.0, 1.0, 1.0}));
        this.INTERACTIVE_APPLICATION_SCOPE.addParameter(new EffortByKeyParameter(this.INTERACTIVE_APPLICATION_SCOPE, Project_Messages.getString("EffortParameters.ImplementationParameter"), new String[]{Project_Messages.getString("EffortParameters.ToDoKey")}, new double[]{1.0}));
        this.INTERACTIVE_APPLICATION_SCOPE.addParameter(new EffortByKeyParameter(this.INTERACTIVE_APPLICATION_SCOPE, Project_Messages.getString("EffortParameters.ComplexityParameter"), new String[]{Project_Messages.getString("EffortParameters.HighKey"), Project_Messages.getString("EffortParameters.MediumKey"), Project_Messages.getString("EffortParameters.LowKey")}, new double[]{1.0, 1.0, 1.0}));
        this.NON_INTERACTIVE_APPLICATION_SCOPE.addParameter(new EffortByKeyParameter(this.NON_INTERACTIVE_APPLICATION_SCOPE, Project_Messages.getString("EffortParameters.TechnologyParameter"), new String[]{Project_Messages.getString("EffortParameters.ToDoKey"), Project_Messages.getString("EffortParameters.NewDevelopmentKey")}, new double[]{1.0, 1.0}));
        this.NON_INTERACTIVE_APPLICATION_SCOPE.addParameter(new EffortByKeyParameter(this.NON_INTERACTIVE_APPLICATION_SCOPE, Project_Messages.getString("EffortParameters.QualityAvailableDocumentationParameter"), new String[]{Project_Messages.getString("EffortParameters.HighKey"), Project_Messages.getString("EffortParameters.MediumKey"), Project_Messages.getString("EffortParameters.LowKey")}, new double[]{1.0, 1.0, 1.0}));
        this.NON_INTERACTIVE_APPLICATION_SCOPE.addParameter(new EffortByKeyParameter(this.NON_INTERACTIVE_APPLICATION_SCOPE, Project_Messages.getString("EffortParameters.TechnologyParameter"), new String[]{Project_Messages.getString("EffortParameters.ToDoKey")}, new double[]{1.0}));
        this.NON_INTERACTIVE_APPLICATION_SCOPE.addParameter(new EffortByKeyParameter(this.NON_INTERACTIVE_APPLICATION_SCOPE, Project_Messages.getString("EffortParameters.ComplexityParameter"), new String[]{Project_Messages.getString("EffortParameters.HighKey"), Project_Messages.getString("EffortParameters.MediumKey"), Project_Messages.getString("EffortParameters.LowKey")}, new double[]{1.0, 1.0, 1.0}));
        this.CONDITIONAL_PERFORMER_SCOPE.addParameter(new EffortByKeyParameter(this.CONDITIONAL_PERFORMER_SCOPE, Project_Messages.getString("EffortParameters.PerformerComplexityParameter"), new String[]{Project_Messages.getString("EffortParameters.ToDoKey")}, new double[]{1.0}));
        this.ROLE_SCOPE.addParameter(new EffortByKeyParameter(this.ROLE_SCOPE, Project_Messages.getString("EffortParameters.RoleComplexityParameter"), new String[]{Project_Messages.getString("EffortParameters.ToDoKey")}, new double[]{1.0}));
        this.ORGANIZATION_SCOPE.addParameter(new EffortByKeyParameter(this.ORGANIZATION_SCOPE, Project_Messages.getString("EffortParameters.OrganizationComplexityParameter"), new String[]{Project_Messages.getString("EffortParameters.ToDoKey")}, new double[]{1.0}));
    }

    private double[] createDoubleArray(int size, double initialValue) {
        double[] result = new double[size];
        Arrays.fill(result, initialValue);
        return result;
    }

    private List<String> collectDataTechnologies() {
        List dataTechnologies = CollectionUtils.newList();
        for (DataTypeType dataType : this.model.getDataType()) {
            dataTechnologies.add(dataType.getName());
        }
        return dataTechnologies;
    }

    private void loadFromModel() {
        this.loading = true;
        int i = 0;
        while (i < this.SCOPES.length) {
            this.SCOPES[i].clear();
            ++i;
        }
        IAttributeCategory planningCat = AttributeUtil.createAttributeCategory((IExtensibleElement)this.model, (String)"project-planning");
        for (IAttributeCategory category : planningCat.getAttributeCategories()) {
            if (!category.getId().startsWith("effortParameter")) continue;
            String scopeClassName = this.getAttribute(category, "scope");
            String filter = this.getAttribute(category, "filter");
            String typeName = this.getAttribute(category, "type");
            String name = this.getAttribute(category, "name");
            String initializers = this.getAttribute(category, "initializers");
            try {
                Class<?> scopeClass = Class.forName(scopeClassName);
                EffortParameterScope scope = this.getScope(scopeClass, filter);
                if (scope == null) continue;
                EffortNotifier parameter = null;
                if ("org.eclipse.stardust.modeling.project.effort.EffortByKeyParameter".equals(typeName)) {
                    parameter = new EffortByKeyParameter(scope, name, initializers);
                }
                if ("org.eclipse.stardust.modeling.project.effort.EffortByQuantityParameter".equals(typeName)) {
                    parameter = new EffortByQuantityParameter(scope, name, initializers);
                }
                scope.addParameter((EffortParameter)((Object)parameter));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (planningCat.getAttributeCategories().isEmpty()) {
            this.initializeDefaults();
        }
        this.loading = false;
        this.modified = false;
        this.notifyListeners(new EffortEvent(this, "scopes", null, null));
    }

    public void saveToModel() {
        this.modified = false;
        IAttributeCategory planningCat = AttributeUtil.createAttributeCategory((IExtensibleElement)this.model, (String)"project-planning");
        for (IAttributeCategory category : planningCat.getAttributeCategories()) {
            planningCat.removeAttributeCategory(category.getId());
        }
        int n = 0;
        int i = 0;
        while (i < this.SCOPES.length) {
            EffortParameterScope scope = this.SCOPES[i];
            Iterator<String> iterator = scope.getNames();
            while (iterator.hasNext()) {
                String name = iterator.next();
                EffortParameter parameter = scope.getParameter(name);
                IAttributeCategory category = planningCat.createAttributeCategory("effortParameter[" + n++ + "]");
                this.setAttribute(category, "scope", scope.getScopeClass().getName());
                this.setAttribute(category, "filter", scope.getFilter());
                this.setAttribute(category, "type", parameter.getClass().getName());
                this.setAttribute(category, "name", name);
                this.setAttribute(category, "initializers", parameter.getInitializers());
            }
            ++i;
        }
        AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)"project-planning:notifier", null);
    }

    private String getAttribute(IAttributeCategory category, String name) {
        AttributeType attribute = category.getAttribute(name);
        return attribute == null ? null : attribute.getValue();
    }

    private void setAttribute(IAttributeCategory category, String name, String value) {
        AttributeType attribute = category.getAttribute(name);
        if (attribute == null) {
            attribute = category.createAttribute(name);
        }
        attribute.setValue(value);
    }

    public void parameterNameChanged(EffortParameter parameter, String newName, String oldName) {
        EffortParameterScope scope = parameter.getScope();
        for (IExtensibleElement extensible : this.getExtensibles(scope)) {
            AttributeType attribute;
            if (!scope.isApplicable(extensible) || (attribute = AttributeUtil.getAttribute((IExtensibleElement)extensible, (String)("project-planning:" + oldName))) == null) continue;
            attribute.setName("project-planning:" + newName);
        }
    }

    public void keyNameChanged(EffortKey key, String newName, String oldName) {
        EffortByKeyParameter parameter = key.getParameter();
        EffortParameterScope scope = parameter.getScope();
        for (IExtensibleElement extensible : this.getExtensibles(scope)) {
            AttributeType attribute;
            if (!scope.isApplicable(extensible) || (attribute = AttributeUtil.getAttribute((IExtensibleElement)extensible, (String)("project-planning:" + parameter.getName()))) == null || !CompareHelper.areEqual((Object)attribute.getValue(), (Object)oldName)) continue;
            attribute.setValue(newName);
        }
    }

    List<IExtensibleElement> getExtensibles(EffortParameterScope scope) {
        List collectibles = CollectionUtils.newList();
        if (this.MODEL_SCOPE == scope) {
            collectibles.add(this.model);
        }
        if (this.PROCESS_SCOPE == scope) {
            collectibles.addAll(this.model.getProcessDefinition());
        }
        if (this.ACTIVITY_SCOPE == scope) {
            for (ProcessDefinitionType process : this.model.getProcessDefinition()) {
                collectibles.addAll(process.getActivity());
            }
        }
        if (this.TRANSITION_SCOPE == scope) {
            for (ProcessDefinitionType process : this.model.getProcessDefinition()) {
                collectibles.addAll(process.getTransition());
            }
        }
        if (this.DATA_SCOPE == scope) {
            collectibles.addAll(this.model.getData());
        }
        if (this.ROLE_SCOPE == scope) {
            collectibles.addAll(this.model.getRole());
        }
        if (this.ORGANIZATION_SCOPE == scope) {
            collectibles.addAll(this.model.getOrganization());
        }
        if (this.CONDITIONAL_PERFORMER_SCOPE == scope) {
            collectibles.addAll(this.model.getConditionalPerformer());
        }
        if (this.INTERACTIVE_APPLICATION_SCOPE == scope) {
            collectibles.addAll(this.model.getApplication());
        }
        if (this.NON_INTERACTIVE_APPLICATION_SCOPE == scope) {
            collectibles.addAll(this.model.getApplication());
        }
        return collectibles;
    }

    public void markModified() {
        if (!this.loading) {
            this.modified = true;
            AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)"project-planning:notifier", (String)"dummy");
        }
    }

    public ModelType getModel() {
        return this.model;
    }
}

