/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;

public class CollectSearchCandidatesVisitor
implements IResourceVisitor {
    public static final String[] CARNOT_EXTENSIONS = new String[]{"xpdl", "cwm"};
    List files = new ArrayList();
    IProject project = null;

    public CollectSearchCandidatesVisitor(IProject project) {
        this.project = project;
    }

    public boolean visit(IResource resource) throws CoreException {
        boolean result = false;
        if (resource instanceof IWorkspaceRoot || resource instanceof IFolder) {
            result = true;
        } else if (resource instanceof IProject && resource.isAccessible()) {
            result = true;
        } else if (resource instanceof IFile && this.project.equals((Object)resource.getProject())) {
            IFile file = (IFile)resource;
            String extension = file.getFileExtension();
            int i = 0;
            while (i < CARNOT_EXTENSIONS.length) {
                if (CARNOT_EXTENSIONS[i].equalsIgnoreCase(extension)) {
                    result = true;
                    this.files.add(file);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public List getFiles() {
        return Collections.unmodifiableList(this.files);
    }
}

