/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.refactoring.RefactoringUtils;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.AttributeValueChange;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.EObjectStringValueSubstituteChange;

public class ApplicationOperator
implements IJdtOperator {
    private String typeId;
    private boolean prefixed;
    private String[] classNames;
    private String[] constructorNames;
    private String[] methodNames;

    public ApplicationOperator(String id, String[] classAttributes, String[] constructorAttributes, String[] methodAttributes) {
        this(id, false, classAttributes, constructorAttributes, methodAttributes);
    }

    public ApplicationOperator(String id, boolean prefixMatch, String[] classAttributes, String[] constructorAttributes, String[] methodAttributes) {
        this.typeId = id;
        this.prefixed = prefixMatch;
        this.classNames = classAttributes;
        this.constructorNames = constructorAttributes;
        this.methodNames = methodAttributes;
    }

    @Override
    public List getRefactoringChanges(ModelType model, Object element, RefactoringArguments arguments) {
        String originalPackageName = null;
        String newPackageName = null;
        if (element instanceof IPackageFragment) {
            originalPackageName = ((IPackageFragment)element).getElementName();
            newPackageName = OperatorsRegistry.getNewPackageName((IPackageFragment)element, arguments);
            if (newPackageName.equals(originalPackageName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalClassName = null;
        String newClassName = null;
        if (element instanceof IType) {
            originalClassName = ((IType)element).getFullyQualifiedName();
            newClassName = OperatorsRegistry.getNewClassName((IType)element, arguments);
            if (newClassName.equals(originalClassName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalMethodName = null;
        String newMethodName = null;
        if (element instanceof IMethod) {
            originalMethodName = ((IMethod)element).getElementName();
            newMethodName = OperatorsRegistry.getNewMethodName((IMethod)element, arguments);
            if (newMethodName.equals(originalMethodName)) {
                return Collections.EMPTY_LIST;
            }
        }
        if (newPackageName == null && newClassName == null && newMethodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList applicationTypes = model.getApplicationType();
        int i = 0;
        while (i < applicationTypes.size()) {
            ApplicationTypeType type = (ApplicationTypeType)applicationTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList pojos = type.getApplications();
                int j = 0;
                while (j < pojos.size()) {
                    ApplicationType application = (ApplicationType)pojos.get(j);
                    if (element instanceof IPackageFragment) {
                        this.processPackages(result, application, originalPackageName, newPackageName);
                    } else if (element instanceof IType) {
                        this.processClasses(result, application, originalClassName, newClassName);
                        this.processParams(result, application, originalClassName, newClassName);
                        this.processAccessPoints(result, application, originalClassName, newClassName);
                    } else if (element instanceof IMethod) {
                        this.processMethods(result, application, originalMethodName, newMethodName);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getQueryMatches(IFile file, ModelType model, Object element) {
        String packageName = null;
        if (element instanceof IPackageFragment) {
            packageName = ((IPackageFragment)element).getElementName();
        }
        String className = null;
        if (element instanceof IType) {
            className = ((IType)element).getFullyQualifiedName();
        }
        String methodName = null;
        if (element instanceof IMethod) {
            methodName = ((IMethod)element).getElementName();
        }
        if (packageName == null && className == null && methodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList applicationTypes = model.getApplicationType();
        int i = 0;
        while (i < applicationTypes.size()) {
            ApplicationTypeType type = (ApplicationTypeType)applicationTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList pojos = type.getApplications();
                int j = 0;
                while (j < pojos.size()) {
                    ApplicationType application = (ApplicationType)pojos.get(j);
                    if (!(element instanceof IPackageFragment)) {
                        if (element instanceof IType) {
                            this.queryClasses(result, file, application, className);
                            this.queryParams(result, file, application, className);
                            this.queryAccessPoints(result, file, application, className);
                        } else if (element instanceof IMethod) {
                            this.queryMethods(result, file, application, methodName);
                        }
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    private void queryAccessPoints(List result, IFile file, ApplicationType application, String className) {
        EList accessPoints = application.getAccessPoint();
        int i = 0;
        while (i < accessPoints.size()) {
            AttributeType attribute;
            AccessPointType ap = (AccessPointType)accessPoints.get(i);
            DataTypeType type = ap.getType();
            if (type != null && "serializable".equals(type.getId()) && (attribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)"carnot:engine:className")) != null && className.equals(attribute.getValue())) {
                result.add(new EObjectMatch(file, attribute, 0, className.length()));
            }
            ++i;
        }
    }

    private void processAccessPoints(List result, ApplicationType application, String originalClassName, String newClassName) {
        EList accessPoints = application.getAccessPoint();
        int i = 0;
        while (i < accessPoints.size()) {
            String className;
            AttributeType attribute;
            AccessPointType ap = (AccessPointType)accessPoints.get(i);
            DataTypeType type = ap.getType();
            if (type != null && "serializable".equals(type.getId()) && (attribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)"carnot:engine:className")) != null && originalClassName.equals(className = attribute.getValue())) {
                result.add(new AttributeValueChange(attribute, newClassName));
            }
            ++i;
        }
    }

    private void queryParams(List result, IFile file, ApplicationType application, String className) {
        int k = 0;
        while (k < this.methodNames.length) {
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)this.methodNames[k]);
            if (attribute != null) {
                EObjectMatch.addParamsMatch(result, file, attribute, className);
            }
            ++k;
        }
    }

    private void processParams(List result, ApplicationType application, String originalClassName, String newClassName) {
        int k = 0;
        while (k < this.methodNames.length) {
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)this.methodNames[k]);
            if (attribute != null) {
                EObjectStringValueSubstituteChange.addParamsSubstitution(result, attribute.getName(), (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalClassName, newClassName);
            }
            ++k;
        }
    }

    private void queryMethods(List result, IFile file, ApplicationType application, String methodName) {
        int k = 0;
        while (k < this.methodNames.length) {
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)this.methodNames[k]);
            if (attribute != null) {
                EObjectMatch.addMethodMatch(result, file, attribute, methodName);
            }
            ++k;
        }
    }

    private void processMethods(List result, ApplicationType application, String originalMethodName, String newMethodName) {
        int k = 0;
        while (k < this.methodNames.length) {
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)this.methodNames[k]);
            if (attribute != null) {
                EObjectStringValueSubstituteChange.addMethodSubstitution(result, attribute.getName(), (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalMethodName, newMethodName);
            }
            ++k;
        }
    }

    private void queryClasses(List result, IFile file, ApplicationType application, String className) {
        int k = 0;
        while (k < this.classNames.length) {
            EList attributes = application.getAttribute();
            int i = 0;
            while (i < attributes.size()) {
                AttributeType attribute = (AttributeType)attributes.get(i);
                if ((this.prefixed && attribute.getName().startsWith(this.classNames[k]) || attribute.getName().equals(this.classNames[k])) && className.equals(attribute.getValue())) {
                    result.add(new EObjectMatch(file, attribute, 0, className.length()));
                    if (!this.prefixed) {
                        this.queryConstructors(result, file, application, className);
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    private void processClasses(List result, ApplicationType application, String originalClassName, String newClassName) {
        int k = 0;
        while (k < this.classNames.length) {
            EList attributes = application.getAttribute();
            int i = 0;
            while (i < attributes.size()) {
                String className;
                AttributeType attribute = (AttributeType)attributes.get(i);
                if ((this.prefixed && attribute.getName().startsWith(this.classNames[k]) || attribute.getName().equals(this.classNames[k])) && originalClassName.equals(className = attribute.getValue())) {
                    result.add(new AttributeValueChange(attribute, newClassName));
                    if (!this.prefixed) {
                        this.processConstructors(result, application, originalClassName, newClassName);
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    private void processPackages(List result, ApplicationType application, String originalClassName, String newClassName) {
        int k = 0;
        while (k < this.classNames.length) {
            EList attributes = application.getAttribute();
            int i = 0;
            while (i < attributes.size()) {
                String className;
                AttributeType attribute = (AttributeType)attributes.get(i);
                if (attribute.getName().startsWith(this.classNames[k]) && RefactoringUtils.containsPackage(className = attribute.getValue(), originalClassName)) {
                    result.add(new AttributeValueChange(attribute, RefactoringUtils.getNewClassName(className, originalClassName, newClassName)));
                }
                ++i;
            }
            ++k;
        }
    }

    private void queryConstructors(List result, IFile file, ApplicationType application, String className) {
        String originalConstructorName = this.getConstructorName(className);
        int l = 0;
        while (l < this.constructorNames.length) {
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)this.constructorNames[l]);
            if (attribute != null) {
                EObjectMatch.addMethodMatch(result, file, attribute, originalConstructorName);
                EObjectMatch.addParamsMatch(result, file, attribute, className);
            }
            ++l;
        }
    }

    private void processConstructors(List result, ApplicationType application, String originalClassName, String newClassName) {
        String originalConstructorName = this.getConstructorName(originalClassName);
        String newConstructorName = this.getConstructorName(newClassName);
        if (!newConstructorName.equals(originalConstructorName)) {
            int l = 0;
            while (l < this.constructorNames.length) {
                AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)this.constructorNames[l]);
                if (attribute != null) {
                    EObjectStringValueSubstituteChange.addMethodSubstitution(result, attribute.getName(), (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalConstructorName, newConstructorName);
                    EObjectStringValueSubstituteChange.addParamsSubstitution(result, attribute.getName(), (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalClassName, newClassName);
                }
                ++l;
            }
        }
    }

    private String getConstructorName(String className) {
        int ix = className.lastIndexOf(46);
        String constructorName = ix < 0 ? className : className.substring(ix + 1);
        return constructorName;
    }
}

