/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.query.participants;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.text.Match;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class MatchPresentation
implements IMatchPresentation {
    public ILabelProvider createLabelProvider() {
        return new EObjectLabelProvider(null){

            public String getText(Object element) {
                IIdentifiableElement object = MatchPresentation.this.fixElement(element);
                if (object instanceof ModelType) {
                    return this.getFixedText((EObject)element);
                }
                return String.valueOf(this.getFixedText((EObject)element, (EObject)object)) + " (" + this.getFixedText(object.eContainer()) + ")";
            }

            public Image getImage(Object element) {
                ModelType modelType;
                if (this.editor == null && (modelType = ModelUtils.findContainingModel((EObject)((EObject)element))) != null) {
                    this.editor = GenericUtils.getWorkflowModelEditor((ModelType)modelType);
                }
                if (this.editor == null) {
                    return null;
                }
                return super.getImage((Object)MatchPresentation.this.fixElement(element));
            }

            private String getFixedText(EObject object) {
                return this.getFixedText(object, null);
            }

            private String getFixedText(EObject object, EObject upTo) {
                if (object instanceof ModelType || object == upTo) {
                    return this.getLabel(object);
                }
                return String.valueOf(this.getFixedText(object.eContainer(), upTo)) + ", " + this.getLabel(object);
            }

            private String getLabel(EObject object) {
                String type = object.eClass().getName();
                if (type.endsWith("Type")) {
                    type = type.substring(0, type.length() - 4);
                }
                return String.valueOf(Character.toUpperCase(type.charAt(0))) + type.substring(1) + ": " + super.getText((Object)object);
            }
        };
    }

    private IIdentifiableElement fixElement(Object element) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return this.findIdentifiable(eObject);
        }
        return null;
    }

    public void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        Object element = match.getElement();
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            IEditorPart part = this.getEditorPart(((EObjectMatch)match).getFile(), activate);
            if (part != null && part instanceof WorkflowModelEditor) {
                WorkflowModelEditor editor = (WorkflowModelEditor)part;
                IIdentifiableElement identifiable = this.findIdentifiable(eObject);
                IIdentifiableElement other = this.findCorrespondingObject(editor.getWorkflowModel(), identifiable);
                IModelElement selection = this.findEditPart(editor, (EObject)other);
                editor.selectElement((EObject)selection);
            }
        }
    }

    private IModelElement findEditPart(WorkflowModelEditor editor, EObject other) {
        EditPart part = null;
        while (part == null || !(other instanceof IModelElement)) {
            part = editor.findEditPart((Object)other);
            if (part != null && other instanceof IModelElement) continue;
            other = other.eContainer();
        }
        return (IModelElement)other;
    }

    private IIdentifiableElement findIdentifiable(EObject eObject) {
        while (!(eObject instanceof IIdentifiableElement)) {
            eObject = eObject.eContainer();
        }
        return (IIdentifiableElement)eObject;
    }

    private IIdentifiableElement findCorrespondingObject(ModelType model, IIdentifiableElement identifiable) {
        if (identifiable instanceof ModelType) {
            return model;
        }
        IIdentifiableElement otherParent = this.findCorrespondingObject(model, (IIdentifiableElement)identifiable.eContainer());
        EClass otherParentClass = otherParent.eClass();
        String featureName = identifiable.eContainingFeature().getName();
        EStructuralFeature feature = otherParentClass.getEStructuralFeature(featureName);
        return ModelUtils.findIdentifiableElement((EObject)otherParent, (EStructuralFeature)feature, (String)identifiable.getId());
    }

    private IEditorPart getEditorPart(IFile file, boolean activate) throws PartInitException {
        int i;
        ArrayList<IEditorReference> refs = new ArrayList<IEditorReference>();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null) {
            i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                IWorkbenchPage[] pages = window.getPages();
                if (pages != null) {
                    int j = 0;
                    while (j < pages.length) {
                        IWorkbenchPage page = pages[j];
                        IEditorReference[] references = page.getEditorReferences();
                        if (references != null) {
                            int k = 0;
                            while (k < references.length) {
                                IFile current;
                                IEditorReference reference = references[k];
                                IEditorInput input = reference.getEditorInput();
                                if (input instanceof FileEditorInput && file.equals((Object)(current = ((FileEditorInput)input).getFile()))) {
                                    refs.add(reference);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (refs.isEmpty()) {
            IWorkbenchWindow wbw = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage wbp = wbw.getActivePage();
            return IDE.openEditor((IWorkbenchPage)wbp, (IFile)file, (boolean)activate);
        }
        i = 0;
        while (i < refs.size()) {
            IEditorReference reference = (IEditorReference)refs.get(i);
            IEditorPart part = reference.getEditor(false);
            if (part instanceof WorkflowModelEditor) {
                return this.activateEditor(reference, activate);
            }
            ++i;
        }
        return this.activateEditor((IEditorReference)refs.get(0), activate);
    }

    private IEditorPart activateEditor(IEditorReference reference, boolean activate) {
        IEditorPart part = reference.getEditor(activate);
        reference.getPage().bringToTop((IWorkbenchPart)part);
        return part;
    }
}

