/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.query.participants;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.refactoring.CollectSearchCandidatesVisitor;
import org.eclipse.stardust.modeling.refactoring.WorkflowModelEditorsCollector;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.participants.MatchPresentation;

public class QueryParticipant
implements IQueryParticipant {
    private IMatchPresentation presentation;

    public int estimateTicks(QuerySpecification specification) {
        return 0;
    }

    public IMatchPresentation getUIParticipant() {
        if (this.presentation == null) {
            this.presentation = new MatchPresentation();
        }
        return this.presentation;
    }

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        block8: {
            WorkflowModelEditorsCollector omc = new WorkflowModelEditorsCollector();
            try {
                IJavaElement element;
                if (!(querySpecification instanceof ElementQuerySpecification) || !((element = ((ElementQuerySpecification)querySpecification).getElement()) instanceof IType) && !(element instanceof IMethod) && !(element instanceof IPackageFragment)) break block8;
                switch (querySpecification.getLimitTo()) {
                    case 2: 
                    case 3: {
                        IJavaSearchScope scope = querySpecification.getScope();
                        IPath[] paths = scope.enclosingProjectsAndJars();
                        int i = 0;
                        while (i < paths.length) {
                            IProject project;
                            IPath path = paths[i];
                            if (path.segmentCount() == 1 && (project = this.getWorkspace().getRoot().getProject(path.segment(0))) != null && project.isOpen()) {
                                this.searchProject(requestor, project, element, monitor, omc);
                            }
                            ++i;
                        }
                        break;
                    }
                }
            }
            finally {
                omc.dispose();
            }
        }
    }

    private void searchProject(ISearchRequestor requestor, IProject project, IJavaElement element, IProgressMonitor monitor, WorkflowModelEditorsCollector omc) throws CoreException {
        CollectSearchCandidatesVisitor candidateCollector = new CollectSearchCandidatesVisitor(project);
        project.accept((IResourceVisitor)candidateCollector);
        List files = candidateCollector.getFiles();
        int i = 0;
        while (i < files.size()) {
            IFile file = (IFile)files.get(i);
            List openedModels = omc.getEditors(file);
            if (openedModels.isEmpty()) {
                ModelType model = this.create(file);
                if (model != null) {
                    this.addModel(file, model, element, requestor);
                }
            } else {
                int j = 0;
                while (j < openedModels.size()) {
                    WorkflowModelEditor editor = (WorkflowModelEditor)openedModels.get(j);
                    this.addModel(file, editor.getWorkflowModel(), element, requestor);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addModel(IFile file, ModelType model, IJavaElement element, ISearchRequestor requestor) {
        List matches = OperatorsRegistry.instance().search(file, model, element);
        int k = 0;
        while (k < matches.size()) {
            Match match = (Match)matches.get(k);
            requestor.reportMatch(match);
            ++k;
        }
    }

    private ModelType create(IFile file) {
        ModelType model = null;
        WorkflowModelManager modelManager = new WorkflowModelManager();
        if (file.exists()) {
            try {
                modelManager.load(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
                model = modelManager.getModel();
            }
            catch (Exception exception) {}
        }
        return model;
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }
}

