/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.refactoring.changes;

import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;

public class EObjectStringValueSubstituteChange
extends Change {
    private static EObjectLabelProvider labelProvider = new EObjectLabelProvider(null);
    private String what;
    private String with;
    private EObject eObject;
    private EStructuralFeature feature;
    private String name;
    private boolean paramSubstitution;

    public EObjectStringValueSubstituteChange(String name, EObject eObject, EStructuralFeature feature, boolean paramSubstitution, String what, String with) {
        this.name = name;
        this.eObject = eObject;
        this.feature = feature;
        this.paramSubstitution = paramSubstitution;
        this.what = what;
        this.with = with;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        this.eObject.eSet(this.feature, (Object)this.substitute((String)this.eObject.eGet(this.feature)));
        return new EObjectStringValueSubstituteChange(this.name, this.eObject, this.feature, this.paramSubstitution, this.with, this.what);
    }

    private String substitute(String oldValue) {
        int fromIndex = this.paramSubstitution ? oldValue.lastIndexOf(40) : 0;
        int toIndex = this.paramSubstitution ? oldValue.length() - 1 : oldValue.lastIndexOf(40);
        String separator = this.paramSubstitution ? "," : ".";
        String prefix = oldValue.substring(0, fromIndex);
        String postfix = oldValue.substring(toIndex);
        String original = oldValue.substring(fromIndex, toIndex);
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        boolean needSeparator = false;
        StringTokenizer st = new StringTokenizer(original, separator);
        while (st.hasMoreTokens()) {
            if (needSeparator) {
                sb.append(separator);
            } else {
                needSeparator = true;
            }
            String token = st.nextToken();
            if (EObjectStringValueSubstituteChange.trim(token, this.paramSubstitution).equals(this.what)) {
                sb.append(StringUtils.replace((String)token, (String)this.what, (String)this.with));
                continue;
            }
            sb.append(token);
        }
        sb.append(postfix);
        return sb.toString();
    }

    private static String trim(String token, boolean paramSubstitution) {
        int ix;
        if (!paramSubstitution && (ix = token.indexOf(40)) >= 0) {
            token = token.substring(0, ix);
        }
        return token.trim();
    }

    public static void addParamsSubstitution(List result, String name, EObject eObject, EStructuralFeature feature, String originalClassName, String newClassName) {
        String oldValue = (String)eObject.eGet(feature);
        if (oldValue != null && oldValue.endsWith(")")) {
            int ix = oldValue.lastIndexOf(40);
            if (ix++ > 0) {
                StringTokenizer st = new StringTokenizer(oldValue.substring(ix, oldValue.length() - 1), ",");
                while (st.hasMoreTokens()) {
                    String token = EObjectStringValueSubstituteChange.trim(st.nextToken(), true);
                    if (!originalClassName.equals(token)) continue;
                    result.add(new EObjectStringValueSubstituteChange(name, eObject, feature, true, originalClassName, newClassName));
                    break;
                }
            }
        }
    }

    public static void addMethodSubstitution(List result, String name, EObject eObject, EStructuralFeature feature, String originalMethodName, String newMethodName) {
        String oldValue = (String)eObject.eGet(feature);
        if (oldValue != null) {
            int ix = oldValue.lastIndexOf(40);
            StringTokenizer st = new StringTokenizer(ix >= 0 ? oldValue.substring(0, oldValue.lastIndexOf(40)) : oldValue, ".");
            while (st.hasMoreTokens()) {
                String token = EObjectStringValueSubstituteChange.trim(st.nextToken(), false);
                if (!originalMethodName.equals(token)) continue;
                result.add(new EObjectStringValueSubstituteChange(name, eObject, feature, false, originalMethodName, newMethodName));
                break;
            }
        }
    }

    public String getName() {
        return this.eObject instanceof AttributeType ? "attribute: " + this.name : String.valueOf(labelProvider.getText((Object)this.eObject)) + ": " + this.name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Object getModifiedElement() {
        return this.eObject;
    }
}

