/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.basic.ui;

import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.modeling.templates.Templates_Messages;
import org.eclipse.stardust.modeling.templates.basic.Templates_Basic_Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ExclusiveChoiceTemplatePage
extends WizardPage {
    private Properties properties;
    private String location;
    private String number;
    private Text numberText;
    private Combo combo;
    private String kindText;

    protected ExclusiveChoiceTemplatePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 128);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        composite.setLayoutData((Object)gd);
        Group group = this.createGroup(composite, Templates_Basic_Messages.TXT_EXCLUSIVE_CHOICE_PATTERN);
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setText(Templates_Basic_Messages.LBL_TXT_NUMBER_OF_ACTIVITIES);
        this.numberText = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.numberText.setLayoutData((Object)data);
        Label kind = new Label((Composite)group, 0);
        kind.setText(Templates_Basic_Messages.LBL_TXT_ACTIVITY_KIND);
        this.combo = new Combo((Composite)group, 8);
        data = new GridData(768);
        data.widthHint = 200;
        this.combo.setLayoutData((Object)data);
        this.combo.setItems(new String[]{Templates_Messages.MANUAL_ACTIVITY, Templates_Messages.APPLICATION_ACTIVITY, Templates_Messages.ROUTE_ACTIVITY});
        this.combo.select(1);
        this.kindText = this.combo.getText();
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExclusiveChoiceTemplatePage.this.kindText = ExclusiveChoiceTemplatePage.this.combo.getText();
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ExclusiveChoiceTemplatePage.this.validateFields();
            }
        };
        this.numberText.addListener(24, listener);
        this.setControl((Control)composite);
        this.validateFields();
    }

    private void validateFields() {
        this.number = this.numberText.getText();
        this.kindText = this.combo.getText();
        if (this.number.length() == 0) {
            this.setErrorMessage(Templates_Basic_Messages.ERR_MSG_PLEASE_PROVIDE_A_VALID_NUMBER_OF_ACTIVITIES);
            this.setPageComplete(false);
            return;
        }
        try {
            int i = Integer.parseInt(this.number);
            if (i < 2 || i > 99) {
                this.setErrorMessage(Templates_Basic_Messages.ERR_MSG_PLEASE_PROVIDE_A_VALID_NUMBER_OF_ACTIVITIES);
                this.setPageComplete(false);
                return;
            }
        }
        catch (Throwable throwable) {
            this.setErrorMessage(Templates_Basic_Messages.ERR_MSG_PLEASE_PROVIDE_A_VALID_NUMBER_OF_ACTIVITIES);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    protected Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        return group;
    }

    public boolean finish(IProgressMonitor monitor) {
        return true;
    }

    public Control getControl() {
        return super.getControl();
    }

    public String getDescription() {
        return super.getDescription();
    }

    protected void initializeDialogUnits(Control testControl) {
        super.initializeDialogUnits(testControl);
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNumber() {
        return this.number;
    }

    public String getKind() {
        return this.kindText;
    }
}

