/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.stardust.modeling.transformation.debug.common.CommonConstants;
import org.eclipse.stardust.modeling.transformation.debug.common.SteppingMode;
import org.eclipse.stardust.modeling.transformation.debug.debugger.RhinoDebugFrame;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugElement;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugTarget;
import org.eclipse.stardust.modeling.transformation.debug.model.JsStackFrame;

public class JsThread
extends JsDebugElement
implements IThread {
    private IBreakpoint[] breakpoints;
    private Throwable suspendedByThrowable = CommonConstants.NO_THROWABLE;
    private boolean isTerminated = false;
    private boolean isSuspended = false;
    private boolean isStepping = false;
    private final List<RhinoDebugFrame> debugFrames = new ArrayList<RhinoDebugFrame>();
    private final Map<RhinoDebugFrame, IStackFrame> framesMap = new HashMap<RhinoDebugFrame, IStackFrame>();

    public JsThread(JsDebugTarget target) {
        super(target);
        this.fireCreationEvent();
    }

    public void addDebugFrame(RhinoDebugFrame debugFrame) {
        this.debugFrames.add(debugFrame);
        JsStackFrame stackFrame = new JsStackFrame(this, debugFrame);
        this.framesMap.put(debugFrame, stackFrame);
    }

    public void removeDebugFrame(RhinoDebugFrame debugFrame) {
        this.debugFrames.remove(debugFrame);
        this.framesMap.remove(debugFrame);
    }

    public void notifyChangeInDebugFrame(RhinoDebugFrame debugFrame) {
        JsStackFrame stackFrame = (JsStackFrame)this.framesMap.get(debugFrame);
        if (stackFrame != null) {
            stackFrame.fireTerminateEvent();
            stackFrame.fireCreationEvent();
        }
    }

    public Throwable getSuspendedByThrowable() {
        return this.suspendedByThrowable;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        IStackFrame[] stackFrames;
        if (this.hasStackFrames()) {
            int idx = this.debugFrames.size();
            stackFrames = new IStackFrame[idx];
            for (RhinoDebugFrame debugFrame : this.debugFrames) {
                stackFrames[--idx] = this.framesMap.get(debugFrame);
            }
        } else {
            stackFrames = new IStackFrame[]{};
        }
        return stackFrames;
    }

    public boolean hasStackFrames() throws DebugException {
        return (this.isSuspended() || this.isStepping()) && this.hasDebugFrames();
    }

    public List<RhinoDebugFrame> getDebugFrames() {
        return this.debugFrames;
    }

    public boolean hasDebugFrames() {
        return !this.debugFrames.isEmpty();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        String message = "Thread";
        if (CommonConstants.NO_THROWABLE != this.suspendedByThrowable) {
            message = String.valueOf(message) + " (suspended by exception)";
        }
        if (this.isStepping()) {
            message = String.valueOf(message) + " (Stepping)";
        }
        return message;
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.breakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void resume() throws DebugException {
        this.resetSuspend();
        this.fireResumeEvent(32);
        int debugFrameSize = this.debugFrames.size();
        if (debugFrameSize != 0) {
            this.debugFrames.get(debugFrameSize - 1).resumeThreadExecution();
        }
    }

    public void suspend() throws DebugException {
        this.setSuspended(true);
        this.fireSuspendEvent(32);
        JsDebugTarget debugTarget = (JsDebugTarget)this.getDebugTarget();
        debugTarget.getSteppingManager().setMode(SteppingMode.BREAK);
    }

    public void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
        this.isStepping = false;
    }

    public void setSuspendedByThrowable(Throwable throwable) throws DebugException {
        this.suspendedByThrowable = throwable;
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void stepInto() throws DebugException {
        this.doStep(SteppingMode.STEP_INTO);
    }

    public void stepOver() throws DebugException {
        this.doStep(SteppingMode.STEP_OVER);
    }

    public void stepReturn() throws DebugException {
        this.doStep(SteppingMode.STEP_OUT);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        this.isTerminated = true;
        int debugFrameSize = this.debugFrames.size();
        if (debugFrameSize != 0) {
            this.debugFrames.get(debugFrameSize - 1).resumeThreadExecution(SteppingMode.TERMINATE);
        }
        this.fireTerminateEvent();
    }

    @Override
    public void fireResumeEvent(int detail) {
        super.fireResumeEvent(detail);
    }

    @Override
    public void fireSuspendEvent(int detail) {
        super.fireSuspendEvent(detail);
    }

    private void doStep(SteppingMode mode) {
        this.isStepping = true;
        this.resetSuspend();
        switch (mode) {
            case STEP_INTO: {
                this.fireResumeEvent(1);
                break;
            }
            case STEP_OUT: {
                this.fireResumeEvent(4);
                break;
            }
            case STEP_OVER: {
                this.fireResumeEvent(2);
            }
        }
        int debugFrameSize = this.debugFrames.size();
        if (debugFrameSize != 0) {
            this.debugFrames.get(debugFrameSize - 1).resumeThreadExecution(mode);
        }
    }

    private void resetSuspend() {
        this.isSuspended = false;
        this.suspendedByThrowable = CommonConstants.NO_THROWABLE;
    }
}

