/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.ValidationExtensionRegistry;

public class BridgeObjectProviderRegistry {
    private final ValidationExtensionRegistry extensionRegistry = new ValidationExtensionRegistry();
    private static final AtomicReference<BridgeObjectProviderRegistry> INSTANCE = new AtomicReference();

    public static IBridgeObjectProvider getBridgeObjectProvider(ITypedElement modelElement) {
        if (INSTANCE.get() == null) {
            INSTANCE.compareAndSet(null, new BridgeObjectProviderRegistry());
        }
        return INSTANCE.get().doGetBridgeObjectProvider(modelElement);
    }

    public IBridgeObjectProvider doGetBridgeObjectProvider(ITypedElement modelElement) {
        IMetaType type = modelElement.getMetaType();
        if (type != null) {
            String id = type.getId();
            IConfigurationElement[] extensions = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.stardust.modeling.validation.bridgeObjectProvider");
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement extension = extensions[i];
                try {
                    Object provider;
                    String dataTypeId = extension.getAttribute("dataTypeId");
                    if (CompareHelper.areEqual((Object)dataTypeId, (Object)id) && IBridgeObjectProvider.class.isInstance(provider = extension.createExecutableExtension("class"))) {
                        return (IBridgeObjectProvider)provider;
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
        return null;
    }

    private BridgeObjectProviderRegistry() {
    }
}

