/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.applicationTypes;

import java.text.MessageFormat;
import java.util.List;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class SessionBean20Validator
implements IModelElementValidator {
    private static final int HOME = 0;
    private static final int REMOTE = 1;
    private static final String[] classAttrNames = new String[]{"carnot:engine:homeInterface", "carnot:engine:remoteInterface", "carnot:engine:jndiPath"};
    private static final String[] interfaceNames = new String[]{"Home", "Remote"};
    private static final String[] methodAttrNames = new String[]{"carnot:engine:createMethodName", "carnot:engine:methodName"};
    private static final String[] methodNames = new String[]{"Creation", "Completion"};

    public Issue[] validate(IModelElement element) throws ValidationException {
        List result = CollectionUtils.newList();
        if (element instanceof ApplicationType) {
            ApplicationType sessionBean = (ApplicationType)element;
            String createdTypeName = this.checkMethod(sessionBean, 0, result);
            this.checkMethod(sessionBean, 1, result);
            String componentTypeName = AttributeUtil.getAttributeValue((IExtensibleElement)sessionBean, (String)classAttrNames[1]);
            if (!StringUtils.isEmpty((String)createdTypeName) && !StringUtils.isEmpty((String)componentTypeName)) {
                TypeFinder typeFinder = new TypeFinder((EObject)sessionBean);
                TypeInfo createdType = typeFinder.findType(createdTypeName);
                TypeInfo componentType = typeFinder.findType(componentTypeName);
                if (!TypeFinder.isAssignable(componentType.getType(), createdType.getType())) {
                    result.add(Issue.warning((EObject)sessionBean, (String)Validation_Messages.SessionBean_IncompatibleCreatedType, (Object)"carnot:engine:createMethodName"));
                }
            }
            this.checkJndiPath(result, (IExtensibleElement)sessionBean);
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private void checkJndiPath(List<Issue> result, IExtensibleElement element) {
        if (AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)classAttrNames[2]) == null) {
            result.add(Issue.warning((EObject)((IModelElement)element), (String)Validation_Messages.Validation_MSG_JNDIPathNotSpecified, (Object)classAttrNames[2]));
        }
    }

    private String checkMethod(ApplicationType sessionBean, int type, List<Issue> issues) {
        TypeFinder typeFinder = new TypeFinder((EObject)sessionBean);
        TypeInfo iType = null;
        boolean isLocal = AttributeUtil.getBooleanValue((IExtensibleElement)sessionBean, (String)"carnot:engine:isLocal");
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)sessionBean, (String)classAttrNames[type]);
        VariableContext variableContext = VariableContextHelper.getInstance().getContext((IModelElement)sessionBean);
        className = variableContext.replaceAllVariablesByDefaultValue(className);
        String rType = null;
        if (className == null) {
            issues.add(Issue.warning((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.MSG_InterfaceNotSpecified, interfaceNames[type]), (Object)classAttrNames[type]));
        } else {
            iType = typeFinder.findType(className);
        }
        if (iType == null) {
            issues.add(Issue.error((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), (Object)classAttrNames[type]));
        } else {
            String method;
            if (!isLocal) {
                Object[] objectArray;
                if (type == 1) {
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = className;
                    objectArray2[1] = EJBObject.class.getName();
                    objectArray = objectArray2;
                    objectArray2[2] = EJBLocalObject.class.getName();
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = className;
                    objectArray3[1] = EJBHome.class.getName();
                    objectArray = objectArray3;
                    objectArray3[2] = EJBLocalHome.class.getName();
                }
                Object[] interfaces = objectArray;
                if (!iType.implementsInterface((String)interfaces[1]) && !iType.implementsInterface((String)interfaces[2])) {
                    issues.add(Issue.warning((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.MSG_SessionBean_InvalidEjbTypeSignature, interfaces), (Object)classAttrNames[type]));
                }
            }
            if (StringUtils.isEmpty((String)(method = AttributeUtil.getAttributeValue((IExtensibleElement)sessionBean, (String)methodAttrNames[type])))) {
                issues.add(Issue.warning((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.MSG_MethodNotSpecified, methodNames[type]), (Object)methodAttrNames[type]));
            } else {
                MethodInfo info = typeFinder.getMethod(iType, method);
                if (info == null) {
                    issues.add(Issue.warning((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.MSG_CantFindMethodInClass, method, iType.getType().getElementName()), (Object)methodAttrNames[type]));
                } else {
                    rType = info.getReturnType();
                }
            }
        }
        return rType;
    }
}

