/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.applicationTypes;

import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.ProjectClassLoader;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.WorkspaceValidationUtils;

public class WebserviceApplicationValidator
implements IModelElementValidator {
    private static final String[] messages = new String[]{Validation_Messages.MSG_NoTypeMappingDefined, Validation_Messages.MSG_XMLTypeHasInvalidMapping, Validation_Messages.MSG_TemplateIsInvalid, Validation_Messages.MSG_WSDL_URLIsInvalid, Validation_Messages.MSG_PropertyNotSet};

    public Issue[] validate(IModelElement element) throws ValidationException {
        List result = CollectionUtils.newList();
        result.addAll(this.checkProperty(element, "carnot:engine:wsdlUrl"));
        result.addAll(this.checkProperty(element, "carnot:engine:wsServiceName"));
        result.addAll(this.checkProperty(element, "carnot:engine:wsPortName"));
        result.addAll(this.checkProperty(element, "carnot:engine:wsOperationName"));
        for (AttributeType attribute : ((IExtensibleElement)element).getAttribute()) {
            String key = attribute.getName();
            if (key.startsWith("carnot:engine:mapping:")) {
                result.addAll(this.checkTypeMapping(element, attribute));
                continue;
            }
            if (key.startsWith("carnot:engine:template:")) {
                result.addAll(this.checkXmlTemplate(element, attribute));
                continue;
            }
            if (!key.equals("carnot:engine:wsdlUrl")) continue;
            result.addAll(this.checkWsdlUrl(element, attribute));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private List<Issue> checkTypeMapping(IModelElement element, AttributeType attribute) {
        List result = CollectionUtils.newList();
        String key = attribute.getName();
        String xmlType = key.substring("carnot:engine:mapping:".length());
        String clazz = attribute.getValue();
        if (StringUtils.isEmpty((String)clazz)) {
            result.add(Issue.warning((EObject)element, (String)MessageFormat.format(messages[0], xmlType)));
        } else {
            TypeFinder finder = new TypeFinder((EObject)element);
            if (finder.findType(clazz) == null) {
                result.add(Issue.warning((EObject)element, (String)MessageFormat.format(messages[1], xmlType, clazz)));
            }
        }
        return result;
    }

    private List<Issue> checkXmlTemplate(IModelElement element, AttributeType attribute) {
        List result = CollectionUtils.newList();
        String key = attribute.getName();
        String name = key.substring("carnot:engine:template:".length());
        String xml = attribute.getValue();
        if (!StringUtils.isEmpty((String)xml)) {
            try {
                XmlUtils.parseString((String)xml);
            }
            catch (Exception exception) {
                result.add(Issue.warning((EObject)element, (String)MessageFormat.format(messages[2], name)));
            }
        }
        return result;
    }

    private List<Issue> checkWsdlUrl(IModelElement element, AttributeType attribute) {
        List result = CollectionUtils.newList();
        String uri = attribute.getValue();
        if (uri != null) {
            uri = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer()).replaceAllVariablesByDefaultValue(uri);
        }
        if (!StringUtils.isEmpty((String)uri)) {
            ClassLoader cclBackup = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    if (Platform.isRunning()) {
                        IProject project = WorkspaceValidationUtils.getProjectFromEObject((EObject)element);
                        Thread.currentThread().setContextClassLoader(new ProjectClassLoader(XmlUtils.class.getClassLoader(), project, uri.startsWith("/") ? uri.substring(1) : uri));
                    }
                    new URL(XmlUtils.resolveResourceUri((String)uri));
                }
                catch (Exception exception) {
                    result.add(Issue.warning((EObject)element, (String)MessageFormat.format(messages[3], uri)));
                    Thread.currentThread().setContextClassLoader(cclBackup);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cclBackup);
            }
        }
        return result;
    }

    private List<Issue> checkProperty(IModelElement element, String name) {
        List result = CollectionUtils.newList();
        String property = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)name);
        if (StringUtils.isEmpty((String)property)) {
            result.add(Issue.error((EObject)element, (String)MessageFormat.format(messages[4], name), (Object)name));
        }
        return result;
    }
}

