/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation;

import java.io.Serializable;
import org.eclipse.emf.ecore.EObject;

public class Issue
implements Serializable {
    public static final Issue[] ISSUE_ARRAY = new Issue[0];
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private final int severity;
    private EObject modelElement;
    private Object feature;
    private String message;

    public static Issue info(EObject element, String message) {
        return new Issue(0, element, message);
    }

    public static Issue info(EObject element, String message, Object feature) {
        return new Issue(0, element, message, feature);
    }

    public static Issue warning(EObject element, String message) {
        return new Issue(1, element, message);
    }

    public static Issue warning(EObject element, String message, Object feature) {
        return new Issue(1, element, message, feature);
    }

    public static Issue error(EObject element, String message) {
        return new Issue(2, element, message);
    }

    public static Issue error(EObject element, String message, Object feature) {
        return new Issue(2, element, message, feature);
    }

    public Issue(int severity, EObject element, String message) {
        this(severity, element, message, null);
    }

    public Issue(int severity, EObject element, String message, Object feature) {
        this.severity = severity;
        this.modelElement = element;
        this.message = message;
        this.feature = feature;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isInfo() {
        return this.getSeverity() == 0;
    }

    public boolean isWarning() {
        return 1 == this.getSeverity();
    }

    public boolean isError() {
        return 2 == this.getSeverity();
    }

    public int getSeverity() {
        return this.severity;
    }

    public EObject getModelElement() {
        return this.modelElement;
    }

    public Object getFeature() {
        return this.feature;
    }
}

