/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.DateUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.CurrentVersion;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class DefaultModelValidator
implements IModelValidator {
    private static final Issue[] ISSUE_ARRAY = new Issue[0];

    @Override
    public Issue[] validate(ModelType model) throws ValidationException {
        IModelElement element = model instanceof IModelElement ? (IModelElement)model : ModelUtils.getIdentifiableModelProxy((EObject)model, ModelType.class);
        ValidationService vs = ValidationService.getInstance();
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (StringUtils.isEmpty((String)model.getId())) {
            result.add(Issue.error((EObject)element, Validation_Messages.MODEL_EmptyId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        } else if (model.getId().length() > 50) {
            result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MODEL_TooLongId, String.valueOf(50)), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (StringUtils.isEmpty((String)model.getName())) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MODEL_EmptyModelName, ValidationService.PKG_CWM.getIIdentifiableElement_Name()));
        }
        AttributeType attrValidFrom = AttributeUtil.getAttribute((IExtensibleElement)model, (String)"carnot:engine:validFrom");
        Date validFrom = null;
        if (attrValidFrom != null) {
            try {
                validFrom = DateUtils.getNoninteractiveDateFormat().parse(attrValidFrom.getAttributeValue());
            }
            catch (ParseException parseException) {
                result.add(Issue.error((EObject)element, Validation_Messages.MODEL_InvalidValidFrom, "carnot:engine:validFrom"));
            }
        }
        AttributeType attrValidTo = AttributeUtil.getAttribute((IExtensibleElement)model, (String)"carnot:engine:validTo");
        Date validTo = null;
        if (attrValidTo != null) {
            try {
                validTo = DateUtils.getNoninteractiveDateFormat().parse(attrValidTo.getAttributeValue());
            }
            catch (ParseException parseException) {
                result.add(Issue.error((EObject)element, Validation_Messages.MODEL_InvalidValidTo, "carnot:engine:validTo"));
            }
        }
        if (validFrom != null && validTo != null && validTo.before(validFrom)) {
            result.add(Issue.error((EObject)element, Validation_Messages.MODEL_ValidFromAfterValidTo, "carnot:engine:validTo"));
        }
        if (!CurrentVersion.getVersionName().equals(model.getCarnotVersion())) {
            DataTypeType dataType = model.getDataType().size() > 0 ? (DataTypeType)model.getDataType().get(0) : null;
            result.add(Issue.warning((EObject)dataType, Validation_Messages.WR_MD_HAS_AN_OLDER_VERSION, ValidationService.PKG_CWM.getModelType_CarnotVersion()));
        }
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)model.getData())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)model.getApplication())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)model.getProcessDefinition())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)model.getOrganization())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)model.getRole())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)model.getConditionalPerformer())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)model.getModeler())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)model.getDiagram())));
        if (ModelUtils.findIdentifiableElement((List)model.getRole(), (String)"Administrator") == null) {
            result.add(Issue.error((EObject)element, Validation_Messages.DefaultModelValidator_MissingAdministrator, "Administrator"));
        }
        return result.toArray(ISSUE_ARRAY);
    }
}

