/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class EventHandlerValidator
implements IModelElementValidator {
    private static final String DEFAULT_PERIOD = "000000:000000:000000:000000:000000:000000";

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        EventHandlerType eventHandler = (EventHandlerType)element;
        if (this.findDuplicateId(eventHandler)) {
            result.add(Issue.error((EObject)eventHandler, Validation_Messages.ERR_EVENTHANDLER_DuplicateId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (eventHandler.getType() == null) {
            result.add(Issue.error((EObject)eventHandler, Validation_Messages.ERR_EVENTHANDLER_NoConditionType, ValidationService.PKG_CWM.getIIdentifiableElement_Name()));
        } else {
            String timerAtt = AttributeUtil.getAttributeValue((IExtensibleElement)eventHandler, (String)"carnot:engine:period");
            if (timerAtt != null) {
                if (timerAtt.equals("")) {
                    result.add(Issue.warning((EObject)eventHandler, Validation_Messages.EventHandlerValidator_MSG_NO_PERIOD_VALUE));
                } else if (timerAtt.equals(DEFAULT_PERIOD)) {
                    result.add(Issue.warning((EObject)eventHandler, Validation_Messages.EventHandlerValidator_MSG_DEFAULT_VALUE_PERIOD));
                }
            }
        }
        ValidationService vs = ValidationService.getInstance();
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)eventHandler.getBindAction())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)eventHandler.getUnbindAction())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)eventHandler.getEventAction())));
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private boolean findDuplicateId(EventHandlerType eventHandler) {
        for (EventHandlerType otherEventHandler : (List)eventHandler.eContainer().eGet(CarnotWorkflowModelPackage.eINSTANCE.getEventHandlerType().eContainingFeature())) {
            if (!otherEventHandler.getId().equals(eventHandler.getId()) || eventHandler.equals(otherEventHandler)) continue;
            return true;
        }
        return false;
    }
}

