/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.util.IConnection;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.validation.IModelValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class ExternalPackagesValidator
implements IModelValidator {
    private static final Issue[] ISSUE_ARRAY = new Issue[0];

    @Override
    public Issue[] validate(ModelType model) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        IConnectionManager connectionManager = model.getConnectionManager();
        if (model.getExternalPackages() != null) {
            for (ExternalPackage externalPackage : model.getExternalPackages().getExternalPackage()) {
                String uri = ExtendedAttributeUtil.getAttributeValue((ExtendedAttributesType)externalPackage.getExtendedAttributes(), (String)"carnot:connection:uri");
                IConnection connection = connectionManager.findConnection(uri);
                if (connection == null) {
                    result.add(Issue.error((EObject)externalPackage, MessageFormat.format(Validation_Messages.MODEL_Connection_NoConnection, externalPackage.getName()), "carnot:connection:uri"));
                    continue;
                }
                ModelType referencedModel = null;
                referencedModel = connectionManager.find(externalPackage);
                if (referencedModel == null) {
                    result.add(Issue.error((EObject)externalPackage, MessageFormat.format(Validation_Messages.MODEL_ReferencedModel_NoModel, externalPackage.getHref()), XpdlPackage.eINSTANCE.getExternalPackage_Href()));
                    continue;
                }
                if (referencedModel.getId().equals(externalPackage.getHref())) continue;
                result.add(Issue.warning((EObject)externalPackage, MessageFormat.format(Validation_Messages.MODEL_ExternalPackage_IDConflict, externalPackage.getHref()), XpdlPackage.eINSTANCE.getExternalPackage_Href()));
            }
        }
        return result.toArray(ISSUE_ARRAY);
    }
}

