/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class ProcessInterfaceValidator
implements IModelElementValidator {
    private static final Issue[] ISSUE_ARRAY = new Issue[0];

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (element instanceof ProcessDefinitionType) {
            ProcessDefinitionType proc = (ProcessDefinitionType)element;
            IdRef externalRef = proc.getExternalRef();
            if (proc.getExternalRef() != null) {
                ProcessDefinitionType referencedProcess = (ProcessDefinitionType)externalRef.get(ProcessDefinitionType.class);
                if (referencedProcess == null || referencedProcess.getFormalParameters() == null) {
                    result.add(Issue.warning((EObject)proc, Validation_Messages.MODEL_ProcessInterface_NotValid, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
                } else {
                    FormalParametersType parameters = proc.getFormalParameters();
                    FormalParametersType referencedParameters = referencedProcess.getFormalParameters();
                    FormalParameterMappingsType mappings = proc.getFormalParameterMappings();
                    for (FormalParameterType referencedParameter : referencedParameters.getFormalParameter()) {
                        FormalParameterType parameter = parameters.getFormalParameter(referencedParameter.getId());
                        if (parameter == null) {
                            result.add(Issue.warning((EObject)proc, MessageFormat.format(Validation_Messages.MODEL_ProcessInterface_ParameterMissing, referencedParameter.getId()), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
                            continue;
                        }
                        if (mappings.getMappedData(parameter) == null) {
                            result.add(Issue.warning((EObject)proc, MessageFormat.format(Validation_Messages.MODEL_ProcessInterface_NoMapping, parameter.getId()), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
                            continue;
                        }
                        if (!ModelUtils.haveDifferentTypes((FormalParameterType)referencedParameter, (FormalParameterType)parameter)) continue;
                        result.add(Issue.warning((EObject)proc, MessageFormat.format(Validation_Messages.MODEL_ProcessInterface_IncompatibleTypes, parameter.getId()), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
                    }
                    for (FormalParameterType parameter : parameters.getFormalParameter()) {
                        FormalParameterType referencedParameter = referencedParameters.getFormalParameter(parameter.getId());
                        if (referencedParameter != null) continue;
                        result.add(Issue.warning((EObject)proc, MessageFormat.format(Validation_Messages.MODEL_ProcessInterface_ParameterPending, parameter.getId()), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
                    }
                }
            }
            if (proc.getFormalParameters() != null) {
                boolean invalid = false;
                if (AttributeUtil.getAttribute((IExtensibleElement)proc, (String)"carnot:engine:externalInvocationType") != null) {
                    for (FormalParameterType parameter : proc.getFormalParameters().getFormalParameter()) {
                        String category = parameter.getDataType().getCarnotType();
                        if (category == null) {
                            if (parameter.getDataType().getBasicType() != null) {
                                category = "primitive";
                            }
                            if (parameter.getDataType().getDeclaredType() != null) {
                                category = "struct";
                            }
                        }
                        if (!"primitive".equals(category) && !"struct".equals(category)) {
                            invalid = true;
                            continue;
                        }
                        DataType dataType = proc.getFormalParameterMappings().getMappedData(parameter);
                        String typeValue = AttributeUtil.getAttributeValue((IExtensibleElement)dataType, (String)"carnot:engine:type");
                        if (!typeValue.equals(Type.Timestamp.getId())) continue;
                        invalid = true;
                    }
                }
                if (invalid) {
                    result.add(Issue.error((EObject)proc, Validation_Messages.MODEL_ProcessInterface_InvalidForExternalInvocation, ValidationService.PKG_CWM.getProcessDefinitionType_FormalParameters()));
                }
            }
        }
        return result.toArray(ISSUE_ARRAY);
    }
}

