/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.triggerTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ScopeUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class ManualTriggerValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        IMetaType metaType;
        ArrayList<Issue> result = new ArrayList<Issue>();
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        String participantId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:participant");
        String typeId = null;
        if (element instanceof TriggerType && (metaType = ((TriggerType)element).getMetaType()) != null && (typeId = metaType.getId()) != null && typeId.equals("scan") && ((TriggerType)element).getAccessPoint().isEmpty()) {
            result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MSG_Scantrigger_NoDocumentDataSpecified, typeId), "carnot:engine:participant"));
        }
        if (participantId == null) {
            result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MSG_Trigger_UnspecifiedParticipant, typeId), "carnot:engine:participant"));
        } else if (model != null) {
            IModelParticipant participant = ModelUtils.findParticipant((String)participantId, (List[])new List[]{model.getRole(), model.getOrganization()});
            if (participant == null) {
                result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MSG_Trigger_InvalidParticipant, participantId, typeId), "carnot:engine:participant"));
            } else {
                HashSet scoped = ScopeUtils.findScopedParticipants((ModelType)model);
                if (scoped.contains(participant) && !ScopeUtils.isValidScopedParticipantForManualTrigger((IModelParticipant)participant)) {
                    result.add(Issue.warning((EObject)element, Validation_Messages.ERR_Trigger_InvalidScopedParticipant, "carnot:engine:participant"));
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

