/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class EnhCommonTab
extends CommonTab {
    private boolean loading;

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.loading = true;
        try {
            super.initializeFrom(configuration);
        }
        finally {
            this.loading = false;
            this.scheduleUpdateJob();
        }
    }

    protected long getUpdateJobDelay() {
        return this.loading ? 10000L : super.getUpdateJobDelay();
    }

    protected String readAttribute(ILaunchConfiguration configuration, String attributeName, String defaultValue) {
        String value = (String)ObjectUtils.nonNullAssert((Object)defaultValue);
        try {
            value = configuration.getAttribute(attributeName, value);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        return value;
    }

    protected boolean readAttribute(ILaunchConfiguration configuration, String attributeName, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            value = configuration.getAttribute(attributeName, value);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        return value;
    }

    protected int readAttribute(ILaunchConfiguration configuration, String attributeName, int defaultValue) {
        int value = defaultValue;
        try {
            value = configuration.getAttribute(attributeName, value);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        return value;
    }

    protected List<String> readAttribute(ILaunchConfiguration configuration, String attributeName, List<String> defaultValue) {
        List value = (List)ObjectUtils.nonNullAssert(defaultValue);
        try {
            value = configuration.getAttribute(attributeName, value);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        return value;
    }

    protected void logReadingError(CoreException e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", 0, NLS.bind((String)"An error occurred while reading launch configuration (name: ''{0}'', id: ''{1}'')", (Object)this.getName(), (Object)this.getId()), (Throwable)e));
    }

    protected class UpdateOnChangeHandler
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            EnhCommonTab.this.updateLaunchConfigurationDialog();
        }
    }
}

