/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.debug.core.util.OverlayLaunchConfiguration;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigUtils;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.internal.ecommons.debug.ui.ECommonsDebugUIPlugin;
import org.eclipse.statet.internal.ecommons.debug.ui.Messages;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.IdentityCollection;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class LaunchConfigManager<TElement>
implements ILaunchConfigurationListener,
Disposable {
    private static final Comparator<ILaunchConfiguration> CONFIG_COMPARATOR = new LaunchConfigUtils.LaunchConfigurationComparator();
    private static final String ACTIVE_CONFIG_KEY = "activeConfig";
    private String contentTypeId;
    private final CopyOnWriteIdentityListSet<Listener> listeners = new CopyOnWriteIdentityListSet();
    private ILaunchConfigurationType configType;
    private @Nullable ImList<ILaunchConfiguration> currentConfigs;
    private @Nullable ILaunchConfiguration activeConfig;
    private String configImageKey;
    private String activeConfigImageKey;

    private static @Nullable ILaunchGroup getLaunchGroup(ILaunchConfigurationType type, String mode) {
        if (!type.supportsMode(mode)) {
            return null;
        }
        String category = type.getCategory();
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        ILaunchGroup extension = null;
        int i = 0;
        while (i < groups.length) {
            extension = groups[i];
            if (category == null ? extension.getCategory() == null && extension.getMode().equals(mode) : category.equals(extension.getCategory()) && extension.getMode().equals(mode)) {
                return extension;
            }
            ++i;
        }
        return null;
    }

    public LaunchConfigManager(String contentTypeId, String configTypeId) {
        this.init(contentTypeId, configTypeId);
    }

    protected LaunchConfigManager() {
    }

    protected void init(String contentTypeId, String configTypeId) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType(configTypeId);
        if (configType == null) {
            throw new IllegalArgumentException("configTypeId= " + configTypeId);
        }
        this.contentTypeId = contentTypeId;
        this.configType = configType;
        launchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        IDialogSettings settings = this.getDialogSettings();
        String s = settings.get(ACTIVE_CONFIG_KEY);
        if (s != null && !s.isEmpty()) {
            for (ILaunchConfiguration config : this.getAvailableConfigs()) {
                if (!s.equals(config.getName())) continue;
                this.setActiveConfig(config);
                break;
            }
        }
        this.initImages();
    }

    private void initImages() {
        this.configImageKey = this.configType.getIdentifier();
        this.activeConfigImageKey = this.configImageKey + "_ActiveConfig";
        ImageRegistry imageRegistry = ECommonsDebugUIPlugin.getInstance().getImageRegistry();
        Image image = DebugUITools.getImage((String)this.configType.getIdentifier());
        if (imageRegistry.getDescriptor(this.configImageKey) == null) {
            imageRegistry.put(this.configImageKey, image);
        }
        if (imageRegistry.getDescriptor(this.activeConfigImageKey) == null) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
            imageDescriptorArray[3] = SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/ovr/selected");
            DecorationOverlayIcon activeConfigImageDescriptor = new DecorationOverlayIcon(image, imageDescriptorArray, new Point(image.getBounds().width, image.getBounds().height));
            imageRegistry.put(this.activeConfigImageKey, (ImageDescriptor)activeConfigImageDescriptor);
        }
    }

    public String getContentTypeId() {
        return this.contentTypeId;
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((Plugin)ECommonsDebugUIPlugin.getInstance(), (String)this.contentTypeId);
    }

    public void dispose() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        if (launchManager != null) {
            launchManager.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        }
        IDialogSettings settings = this.getDialogSettings();
        settings.put(ACTIVE_CONFIG_KEY, this.activeConfig != null ? this.activeConfig.getName() : null);
    }

    protected byte getBits(IdentityCollection<String> flags) {
        return 0;
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        try {
            if (configuration.getType() == this.configType) {
                if (DebugPlugin.getDefault().getLaunchManager().getMovedFrom(configuration) == this.activeConfig) {
                    this.update(true, true, configuration);
                } else {
                    this.update(true, false, null);
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        try {
            if (configuration.getType() == this.configType && !configuration.isWorkingCopy()) {
                if (DebugPlugin.getDefault().getLaunchManager().getMovedFrom(configuration) == this.activeConfig) {
                    this.update(true, true, configuration);
                } else {
                    this.update(true, false, null);
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        block4: {
            try {
                if (configuration == this.activeConfig) {
                    this.update(true, true, null);
                    break block4;
                }
                ImList<ILaunchConfiguration> configs = this.currentConfigs;
                if (configs == null) break block4;
                for (ILaunchConfiguration config : configs) {
                    if (config != configuration) continue;
                    this.update(true, false, null);
                    break;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private synchronized void update(boolean updateList, boolean updateActive, @Nullable ILaunchConfiguration newActive) throws CoreException {
        if (updateActive && this.activeConfig == newActive) {
            updateActive = false;
        }
        ImIdentityList listeners = this.listeners.toList();
        if (updateActive) {
            this.activeConfig = newActive;
        }
        if (updateList) {
            if (!listeners.isEmpty()) {
                ImList<ILaunchConfiguration> configs = this.updateAvailableConfigs();
                for (Listener listener : listeners) {
                    try {
                        listener.availableConfigChanged(configs);
                    }
                    catch (Exception e) {
                        ECommonsDebugUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", 0, "An error occurred while notifying a listener.", (Throwable)e));
                    }
                }
            } else {
                this.currentConfigs = null;
            }
        }
        if (updateActive) {
            for (Listener listener : listeners) {
                try {
                    listener.activeConfigChanged(newActive);
                }
                catch (Exception e) {
                    ECommonsDebugUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", 0, "An error occurred while notifying a listener.", (Throwable)e));
                }
            }
        }
    }

    private ImList<ILaunchConfiguration> updateAvailableConfigs() throws CoreException {
        this.currentConfigs = ImCollections.newList((Object[])DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.configType), CONFIG_COMPARATOR);
        return this.currentConfigs;
    }

    public void addListener(Listener listener) {
        this.listeners.add((Object)((Listener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removeListener(Listener listener) {
        this.listeners.remove((Object)listener);
    }

    public ILaunchConfigurationType getConfigurationType() {
        return this.configType;
    }

    public ImList<ILaunchConfiguration> getAvailableConfigs() {
        ImList configs = this.currentConfigs;
        if (configs == null) {
            try {
                configs = this.updateAvailableConfigs();
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", -1, "Loading available configurations failed.", (Throwable)e));
                configs = ImCollections.emptyList();
            }
        }
        return configs;
    }

    public void setActiveConfig(ILaunchConfiguration configuration) {
        try {
            this.update(false, true, configuration);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", -1, "Setting configuration as default failed.", (Throwable)e));
        }
    }

    public @Nullable ILaunchConfiguration getActiveConfig() {
        return this.activeConfig;
    }

    public void openConfigurationDialog(Shell shell, @Nullable IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            String name;
            selection = new StructuredSelection((Object)this.configType);
            if (this.getAvailableConfigs().isEmpty() && (name = this.getAutogenConfigName()) != null) {
                try {
                    name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(name);
                    ILaunchConfigurationWorkingCopy config = this.configType.newInstance(null, name);
                    this.initAutogenConfig(config);
                    selection = new StructuredSelection((Object)config.doSave());
                }
                catch (CoreException e) {
                    ECommonsDebugUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", NLS.bind((String)"An error occurred when generating launch configuration for ''{0}''.", (Object)this.configType.getIdentifier()), (Throwable)e));
                }
            }
        }
        String groupId = LaunchConfigManager.getLaunchGroup(this.configType, "run").getIdentifier();
        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)shell, (IStructuredSelection)selection, (String)groupId);
    }

    public void launch(final ILaunchConfiguration configuration, final TElement element, final IdentitySet<String> flags) {
        String label = this.getLabel(configuration, (IdentityCollection<String>)flags, true);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                try {
                    try {
                        OverlayLaunchConfiguration config = new OverlayLaunchConfiguration(configuration, LaunchConfigManager.this.createRunAttributes(element, (IdentitySet<String>)flags));
                        String mode = "run";
                        byte bits = LaunchConfigManager.this.getBits((IdentityCollection<String>)flags);
                        config.launch("run", (IProgressMonitor)m.newChild(1), LaunchConfigManager.this.getBuildBeforeLaunch(bits), false);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    m.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", 0, String.format(Messages.Run_Launch_error_message, label), e.getTargetException()), 3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected abstract Map<String, Object> createRunAttributes(TElement var1, IdentitySet<String> var2);

    protected boolean getBuildBeforeLaunch(byte bits) {
        return true;
    }

    public ImageDescriptor getImageDescriptor(ILaunchConfiguration configuration) {
        return ECommonsDebugUIPlugin.getInstance().getImageRegistry().getDescriptor(this.activeConfig == configuration ? this.activeConfigImageKey : this.configImageKey);
    }

    public Image getImage(ILaunchConfiguration configuration) {
        return ECommonsDebugUIPlugin.getInstance().getImageRegistry().get(this.activeConfig == configuration ? this.activeConfigImageKey : this.configImageKey);
    }

    public String getLabel(@Nullable ILaunchConfiguration configuration, IdentityCollection<String> flags, boolean noMnemonics) {
        Object label = this.getActionLabel(flags);
        if (configuration != null) {
            label = (String)label + " '" + configuration.getName() + "'";
        }
        return noMnemonics ? MessageUtils.removeMnemonics((String)label) : label;
    }

    public @Nullable Image getActionImage(IdentityCollection<String> flags) {
        return this.getActionImage(this.getBits(flags));
    }

    protected @Nullable Image getActionImage(byte bits) {
        switch (bits) {
            case 0: {
                return ECommonsDebugUIPlugin.getInstance().getImageRegistry().get(this.configImageKey);
            }
        }
        return null;
    }

    public String getActionLabel(IdentityCollection<String> flags) {
        return this.getActionLabel(this.getBits(flags));
    }

    protected abstract String getActionLabel(byte var1);

    protected @Nullable String getAutogenConfigName() {
        return null;
    }

    protected void initAutogenConfig(ILaunchConfigurationWorkingCopy config) {
    }

    public static interface Listener {
        public void activeConfigChanged(ILaunchConfiguration var1);

        public void availableConfigChanged(ImList<ILaunchConfiguration> var1);
    }
}

