/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.internal.jcommons.io.AbstractArchiveUriUrl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class JarUriUrl
extends AbstractArchiveUriUrl {
    private final int scheme2SepIndex;
    private final int jarSepIndex;

    public JarUriUrl(URI url, int schemeSep2Index, int jarSepIndex) {
        super(url);
        this.scheme2SepIndex = schemeSep2Index;
        this.jarSepIndex = jarSepIndex;
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public String getOuterArchiveType() {
        return "jar";
    }

    @Override
    public String getOuterArchiveScheme() {
        return this.getUrl().getSchemeSpecificPart().substring(0, this.scheme2SepIndex);
    }

    @Override
    protected URI createOuterArchiveUrl(URI url) throws URISyntaxException {
        String ssp = url.getSchemeSpecificPart();
        return new URI(ssp.substring(0, this.scheme2SepIndex), ssp.substring(this.scheme2SepIndex + 1, this.jarSepIndex), url.getFragment());
    }

    @Override
    public String getInnerArchiveType() {
        return "jar";
    }

    @Override
    public URI getInnerArchiveUrl() throws URISyntaxException {
        return this.getOuterArchiveUrl();
    }

    @Override
    public String getInnerArchiveUrlString() throws URISyntaxException {
        return this.getOuterArchiveUrlString();
    }

    @Override
    protected String createEntryPath(URI url) {
        String ssp = url.getSchemeSpecificPart();
        return ssp.substring(this.jarSepIndex + 2, ssp.length());
    }
}

