/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.graphic.core;

import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.graphic.core.ColorRefDef;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ColorAlphaDef
extends ColorRefDef {
    private final int alpha;

    public ColorAlphaDef(ColorDef ref, float alpha) {
        super(ref);
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("alpha");
        }
        this.alpha = (int)(alpha * 255.0f + 0.5f);
    }

    public ColorAlphaDef(ColorDef ref, int alpha) {
        super(ref);
        if ((alpha & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("alpha");
        }
        this.alpha = alpha;
    }

    @Override
    public String getType() {
        return "+A";
    }

    public int getAlpha() {
        return this.alpha;
    }

    public final int getRGBA() {
        return this.rgb << 8 | this.alpha;
    }

    public final String getRGBAHexString() {
        byte[] latin1 = new byte[8];
        int code = (this.rgb & 0xFF) << 24 | (this.rgb & 0xFF00) << 8 | (this.rgb & 0xFF0000) >>> 8 | this.alpha;
        int i = 8;
        do {
            --i;
            latin1[i] = switch (code & 0xF) {
                case 0 -> 48;
                case 1 -> 49;
                case 2 -> 50;
                case 3 -> 51;
                case 4 -> 52;
                case 5 -> 53;
                case 6 -> 54;
                case 7 -> 55;
                case 8 -> 56;
                case 9 -> 57;
                case 10 -> 65;
                case 11 -> 66;
                case 12 -> 67;
                case 13 -> 68;
                case 14 -> 69;
                case 15 -> 70;
                default -> 0;
            };
            code >>>= 4;
        } while (i > 0);
        return new String(latin1, 0, 0, latin1.length);
    }

    @Override
    public int hashCode() {
        return this.rgb * 31 + this.alpha;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof ColorAlphaDef)) break block3;
                ColorAlphaDef other = (ColorAlphaDef)obj;
                if (this.alpha == other.alpha && this.getRef().equals(other.getRef())) break block2;
            }
            return false;
        }
        return true;
    }

    @Override
    public void toString(StringBuilder sb) {
        this.getRef().toString(sb);
        sb.append(" \u00d7 \u03b1= ");
        sb.append(this.alpha);
    }
}

