/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.rmi;

import java.io.File;
import java.net.BindException;
import java.net.InetAddress;
import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.eclipse.statet.internal.jcommons.rmi.Messages;
import org.eclipse.statet.internal.jcommons.rmi.eplatform.EPlatformContributor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.PortRange;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.jcommons.rmi.RMIUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.ProcessUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public class RMIRegistryManager {
    private static final String EMBEDDED_PORT_RANGE_KEY = "org.eclipse.statet.jcommons.rmi.registry.TcpPort";
    private static final PortRange EMBEDDED_PORT_RANGE_DEFAULT = new PortRange(51100, 51199);
    public static final RMIRegistryManager INSTANCE = new RMIRegistryManager();
    private final Map<Port, ManagedRegistry> registries = new HashMap<Port, ManagedRegistry>();
    private final Object embeddedLock = new Object();
    private PortRange embeddedPortRange;
    private boolean embeddedStartSeparate = true;
    private boolean embeddedSsl = false;
    private @Nullable ManagedRegistry embeddedRegistry;
    private final List<ManagedRegistry> embeddedRegistries = new ArrayList<ManagedRegistry>(4);
    private @Nullable List<URI> embeddedCodebaseEntries;
    private boolean embeddedCodebaseLoadContrib;

    private RMIRegistryManager() {
        this.initDispose();
        this.embeddedPortRange = EMBEDDED_PORT_RANGE_DEFAULT;
        String s = System.getProperty(EMBEDDED_PORT_RANGE_KEY);
        if (s != null && s.length() > 0) {
            try {
                this.embeddedPortRange = PortRange.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", "The value of the Java property 'org.eclipse.statet.jcommons.rmi.registry.TcpPort' is invalid.", e));
            }
        }
        this.embeddedCodebaseLoadContrib = true;
    }

    protected void initDispose() {
        CommonsRuntime.getEnvironment().addStoppingListener(this::dispose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable RMIRegistry getRegistry(int port) {
        ManagedRegistry r;
        if (port <= 0) {
            port = 1099;
        }
        Port key = new Port(port);
        RMIRegistryManager rMIRegistryManager = this;
        synchronized (rMIRegistryManager) {
            r = this.registries.get(key);
        }
        return r != null ? r.registry : null;
    }

    public void setEmbeddedPrivatePort(int port) {
        this.setEmbeddedPrivatePortDynamic(port, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEmbeddedPrivatePortDynamic(int min, int max) {
        if (min > 0 && min > max) {
            throw new IllegalArgumentException("min > max");
        }
        Object object = this.embeddedLock;
        synchronized (object) {
            this.embeddedRegistry = null;
            this.embeddedPortRange = min > 0 ? new PortRange(min, max) : EMBEDDED_PORT_RANGE_DEFAULT;
        }
    }

    public void setEmbeddedPrivateMode(boolean separate) {
        this.setEmbeddedPrivateMode(separate, this.embeddedSsl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEmbeddedPrivateMode(boolean separate, boolean ssl) {
        if (separate && ssl) {
            throw new IllegalArgumentException("ssl is only supported if separate is not enabled");
        }
        Object object = this.embeddedLock;
        synchronized (object) {
            this.embeddedRegistry = null;
            this.embeddedStartSeparate = separate;
            this.embeddedSsl = ssl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmbeddedCodebaseEntry(URI entry) {
        if (entry.getScheme() == null) {
            throw new IllegalArgumentException("entry: missing scheme");
        }
        Object object = this.embeddedLock;
        synchronized (object) {
            List<URI> embeddedCodebaseEntries = this.embeddedCodebaseEntries;
            if (embeddedCodebaseEntries == null) {
                this.embeddedCodebaseEntries = embeddedCodebaseEntries = new ArrayList<URI>();
            }
            if (!embeddedCodebaseEntries.contains(entry)) {
                this.embeddedRegistry = null;
                embeddedCodebaseEntries.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMIRegistry getEmbeddedPrivateRegistry(ProgressMonitor m) throws StatusException {
        ManagedRegistry r2 = null;
        Status status = null;
        Object object = this.embeddedLock;
        synchronized (object) {
            block19: {
                r2 = this.embeddedRegistry;
                if (r2 != null) {
                    return r2.registry;
                }
                for (ManagedRegistry r2 : this.embeddedRegistries) {
                    RMIAddress address = r2.registry.getAddress();
                    if (!this.embeddedPortRange.contains(address.getPort()) || address.isSsl() != this.embeddedSsl || this.embeddedStartSeparate != (r2.process != null)) continue;
                    this.embeddedRegistry = r2;
                    return r2.registry;
                }
                r2 = null;
                m.beginTask("Starting embedded service registry", -1);
                m.beginSubTask(this.embeddedStartSeparate ? "Starting service registry (RMI) process." : "Starting service registry (RMI).");
                List<URI> embeddedCodebaseEntries = this.embeddedStartSeparate ? this.getEmbeddedCodebaseEntries() : null;
                int loop = 1;
                BindException bindException = null;
                int portNum = this.embeddedPortRange.getMin();
                while (true) {
                    block18: {
                        m.checkCanceled();
                        try {
                            RMIAddress rmiAddress = new RMIAddress(InetAddress.getLoopbackAddress(), new Port(portNum), this.embeddedSsl ? RMIAddress.SSL : null, "");
                            if (this.embeddedStartSeparate) {
                                status = this.startSeparateRegistry(rmiAddress, false, this.embeddedPortRange.getLength() == 1, 2, StopRule.ALWAYS, embeddedCodebaseEntries);
                                if (status.getSeverity() < 4) {
                                    r2 = this.registries.get(rmiAddress.getPort());
                                }
                            } else {
                                Registry javaRegistry = rmiAddress.isSsl() ? LocateRegistry.createRegistry(portNum, new SslRMIClientSocketFactory(), new SslRMIServerSocketFactory(null, null, true)) : LocateRegistry.createRegistry(portNum);
                                r2 = new ManagedRegistry(new RMIRegistry(rmiAddress, javaRegistry, false), 2, StopRule.ALWAYS);
                            }
                            if (r2 == null) break block18;
                            this.embeddedRegistry = r2;
                            this.embeddedRegistries.add(r2);
                            break block19;
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof BindException) {
                                bindException = (BindException)e;
                            }
                            status = new ErrorStatus("org.eclipse.statet.jcommons.util", "An exception was thrown when starting the embedded registry.", e);
                        }
                    }
                    if (++portNum % 10 == 0) {
                        portNum += 10;
                    }
                    if (portNum <= this.embeddedPortRange.getMax()) continue;
                    if (loop != true) break;
                    loop = 2;
                    portNum = this.embeddedPortRange.getMin() + 10;
                    if (portNum > this.embeddedPortRange.getMax()) break;
                }
                if (status == null) {
                    status = new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to bind the embedded RMI registry to a TCP port in the specified range (%1$s).", this.embeddedPortRange), bindException);
                }
            }
        }
        if (r2 != null) {
            object = this;
            synchronized (object) {
                this.registries.put(r2.registry.getAddress().getPort(), r2);
            }
            return r2.registry;
        }
        throw new StatusException(ObjectUtils.nonNullAssert(status));
    }

    private @Nullable List<URI> getEmbeddedCodebaseEntries() {
        List<URI> embeddedCodebaseEntries = this.embeddedCodebaseEntries;
        if (this.embeddedCodebaseLoadContrib) {
            if (embeddedCodebaseEntries == null) {
                this.embeddedCodebaseEntries = embeddedCodebaseEntries = new ArrayList<URI>();
            }
            try {
                this.embeddedCodebaseLoadContrib = false;
                new EPlatformContributor().addCodebaseEntries(embeddedCodebaseEntries);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return embeddedCodebaseEntries;
    }

    public Status startSeparateRegistry(RMIAddress address, boolean allowExisting, @Nullable StopRule stopRule, @Nullable List<URI> codebaseEntries) {
        return this.startSeparateRegistry(address, allowExisting, false, 0, stopRule, codebaseEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status startSeparateRegistry(RMIAddress address, boolean allowExisting, boolean noCheck, int addType, @Nullable StopRule stopRule, @Nullable List<URI> codebaseEntries) {
        Process process;
        int i;
        Status status;
        if (allowExisting && codebaseEntries != null) {
            throw new IllegalArgumentException("allow existing not valid in combination with codebase entries");
        }
        if (!address.isResolved()) {
            throw new IllegalArgumentException("address: not resolved");
        }
        InetAddress hostInetAddress = address.getHostInetAddress();
        if (!hostInetAddress.isLinkLocalAddress() && !hostInetAddress.isLoopbackAddress()) {
            throw new IllegalArgumentException("address: not local");
        }
        if (address.getName() != null) {
            address = new RMIAddress(address, "");
        }
        if (!noCheck && (status = this.checkRegistryAddress(address, allowExisting)) != null) {
            return status;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        try {
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            sb.append(System.getProperty("java.home"));
            sb.append(File.separator).append("bin");
            sb.append(File.separator).append("rmiregistry");
            processBuilder.command().add(sb.toString());
            processBuilder.command().add(address.getPort().toString());
            if (codebaseEntries != null && !codebaseEntries.isEmpty()) {
                sb.setLength(0);
                sb.append("-J-Djava.rmi.server.codebase=");
                sb.append(codebaseEntries.get(0));
                i = 1;
                while (i < codebaseEntries.size()) {
                    sb.append(' ');
                    sb.append(codebaseEntries.get(i));
                    ++i;
                }
                processBuilder.command().add(sb.toString());
            }
            if (address.getHost() != null) {
                sb.setLength(0);
                sb.append("-J-Djava.rmi.server.hostname=");
                sb.append(address.getHost());
                processBuilder.command().add(sb.toString());
            }
            processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
        }
        catch (Exception e) {
            return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStartFailed_message, address.getPort()), e);
        }
        RemoteException lastException = null;
        i = 1;
        while (true) {
            try {
                int exit = process.exitValue();
                return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStartFailedWithExitValue_message, address.getPort(), exit) + "\n\tcommandLine= " + ProcessUtils.generateCommandLine(processBuilder.command()));
            }
            catch (IllegalThreadStateException exit) {
                if (i > 1) {
                    try {
                        RMIUtils.checkRegistryAccess(address);
                        Registry registry = LocateRegistry.getRegistry(address.getHost(), address.getPort().get());
                        registry.list();
                        ManagedRegistry r = new ManagedRegistry(new RMIRegistry(address, registry, true), 1 | addType, stopRule != null ? stopRule : StopRule.IF_EMPTY);
                        r.process = process;
                        RMIRegistryManager rMIRegistryManager = this;
                        synchronized (rMIRegistryManager) {
                            this.registries.put(address.getPort(), r);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (RemoteException e) {
                        lastException = e;
                    }
                }
                if (Thread.interrupted()) {
                    process.destroy();
                    return Status.CANCEL_STATUS;
                }
                if (i >= 25) {
                    process.destroy();
                    return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStartFailed_message, address.getPort()) + "\n\tcommandLine= " + ProcessUtils.generateCommandLine(processBuilder.command()), lastException);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++i;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable Status checkRegistryAddress(RMIAddress address, boolean allowExisting) {
        try {
            RMIUtils.checkRegistryAccess(address);
        }
        catch (RemoteException e) {
            return null;
        }
        if (allowExisting) {
            try {
                Registry registry = LocateRegistry.getRegistry(address.getHost(), address.getPortNum());
                registry.list();
                RMIRegistryManager rMIRegistryManager = this;
                synchronized (rMIRegistryManager) {
                    if (!this.registries.containsKey(address.getPort())) {
                        ManagedRegistry r = new ManagedRegistry(new RMIRegistry(address, registry, false), 4, StopRule.NEVER);
                        this.registries.put(address.getPort(), r);
                    }
                }
                return new InfoStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryAlreadyStarted_message, address.getPort()));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStartFailedPortAlreadyUsed_message, address.getPort()));
    }

    public Status stopSeparateRegistry(RMIAddress address) {
        return this.stopSeparateRegistry(address.getPort().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status stopSeparateRegistry(int port) {
        Process process;
        if (port <= 0) {
            port = 1099;
        }
        Port key = new Port(port);
        RMIRegistryManager rMIRegistryManager = this;
        synchronized (rMIRegistryManager) {
            ManagedRegistry r = this.registries.get(key);
            if (r == null || (process = r.process) == null) {
                return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStopFailedNotFound_message, port));
            }
            this.registries.remove(key);
        }
        process.destroy();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dispose() {
        RMIRegistryManager rMIRegistryManager = this;
        synchronized (rMIRegistryManager) {
            block10: for (ManagedRegistry r : this.registries.values()) {
                Process process = r.process;
                if (process == null) continue;
                switch (r.stopRule) {
                    case ALWAYS: {
                        break;
                    }
                    case NEVER: {
                        continue block10;
                    }
                    case IF_EMPTY: {
                        try {
                            Registry registry = r.registry.getRegistry();
                            if (registry.list().length <= 0) break;
                            continue block10;
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
                process.destroy();
                r.process = null;
            }
            this.registries.clear();
            return;
        }
    }

    private static final class ManagedRegistry {
        public static final int SEPERATE = 1;
        public static final int EMBEDDED = 2;
        public static final int FOREIGN = 4;
        private final RMIRegistry registry;
        private final int type;
        private final StopRule stopRule;
        private @Nullable Process process;

        public ManagedRegistry(RMIRegistry registry, int type, StopRule stopRule) {
            this.registry = registry;
            this.type = type;
            this.stopRule = stopRule;
        }

        public String toString() {
            ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(ManagedRegistry.class);
            sb.append(' ');
            sb.append(this.registry.getAddress().toString());
            sb.addProp("type", this.type);
            sb.addProp("stopRule", (Object)this.stopRule);
            return sb.toString();
        }
    }

    public static enum StopRule {
        ALWAYS,
        NEVER,
        IF_EMPTY;

    }
}

