/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilter;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilter.FilterType;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class IntervalVariableFilter
extends VariableFilter {
    private static final int MIN_IDX = 0;
    private static final int MAX_IDX = 1;
    private static final int NA_IDX = 2;
    private @Nullable Data data;
    private final IObservableValue<Number> selectedLowerValue;
    private final IObservableValue<Number> selectedUpperValue;
    private final IObservableValue<Boolean> selectedNA;

    protected IntervalVariableFilter(FilterSet set, RDataTableColumn column) {
        super(set, column);
        this.selectedLowerValue = new WritableValue(set.getRealm());
        this.selectedUpperValue = new WritableValue(set.getRealm());
        this.selectedNA = new WritableValue(set.getRealm(), (Object)true, Boolean.TYPE);
        this.registerObservable((IObservable)this.selectedLowerValue);
        this.registerObservable((IObservable)this.selectedUpperValue);
        this.registerObservable((IObservable)this.selectedNA);
    }

    @Override
    public FilterType getType() {
        return FilterType.INTERVAL;
    }

    @Override
    public void load(VariableFilter filter) {
        if (filter.getType() == FilterType.INTERVAL && filter.getColumn().getDataStore().getStoreType() == this.getColumn().getDataStore().getStoreType()) {
            IntervalVariableFilter intervalFilter = (IntervalVariableFilter)filter;
            this.runInRealm(() -> {
                Data minMaxData = this.data;
                if (minMaxData != null || (minMaxData = intervalVariableFilter.data) == null) {
                    return;
                }
                this.data = minMaxData;
                this.selectedLowerValue.setValue((Object)((Number)intervalFilter.getSelectedLowerValue().getValue()));
                this.selectedUpperValue.setValue((Object)((Number)intervalFilter.getSelectedUpperValue().getValue()));
                this.selectedNA.setValue((Object)((Boolean)intervalFilter.getSelectedNA().getValue()));
            });
        }
    }

    @Override
    public void reset() {
        this.runInRealm(() -> {
            Data data = this.data;
            if (data == null) {
                return;
            }
            this.selectedLowerValue.setValue((Object)data.getMin());
            this.selectedUpperValue.setValue((Object)data.getMax());
            this.selectedNA.setValue((Object)Boolean.TRUE);
        });
    }

    @Override
    protected void updateData(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RDataTableColumn column = this.getColumn();
        FunctionCall fcall = r.createFunctionCall("rj:::.getDataIntervalValues");
        fcall.add(column.getRExpression());
        RObject rData = fcall.evalData(m);
        RDataUtils.checkRVector((RObject)rData);
        RStore rStore = RDataUtils.checkData((RStore)rData.getData(), (byte)column.getDataStore().getStoreType());
        RDataUtils.checkLengthGreaterOrEqual((RStore)rStore, (long)3L);
        boolean hasMinMax = !rStore.isMissing(0) && !rStore.isMissing(1);
        boolean hasNA = rStore.getLogi(2);
        if (rStore.getStoreType() == 3) {
            this.setFilterData(hasMinMax ? new NumData(rStore.getNum(0), rStore.getNum(1), hasNA) : new NumData(hasNA));
        } else {
            this.setFilterData(hasMinMax ? new IntData(rStore.getInt(0), rStore.getInt(1), hasNA) : new IntData(hasNA));
        }
    }

    @Override
    protected void setStatus(IStatus status) {
        this.runInRealm(() -> {
            this.data = null;
            this.doSetStatus(status);
            this.updateFilter(1);
            this.notifyListeners();
        });
    }

    protected void setFilterData(Data data) {
        this.runInRealm(() -> {
            Data prevData = this.data;
            this.data = data;
            Number value = (Number)this.selectedLowerValue.getValue();
            if (!data.isValidValue(value) || prevData == null || value.equals(prevData.getMin())) {
                this.selectedLowerValue.setValue((Object)data.getMin());
            }
            if (!data.isValidValue(value = (Number)this.selectedLowerValue.getValue()) || prevData == null || value.equals(prevData.getMax())) {
                this.selectedUpperValue.setValue((Object)data.getMax());
            }
            this.clearStatus();
            this.updateFilter(1);
            this.notifyListeners();
        });
    }

    @Override
    protected @Nullable String createFilter(String varExpression) {
        Number upper;
        Number lower;
        Data data = this.data;
        if (data == null || (lower = (Number)this.selectedLowerValue.getValue()) == null || (upper = (Number)this.selectedUpperValue.getValue()) == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int num = 0;
        int na = 0;
        if (data.hasMinMax()) {
            if (data.isGreaterThanMin(lower)) {
                sb.append(varExpression);
                sb.append(" >= ");
                sb.append(lower);
                ++num;
            }
            if (data.isSmallerThanMax(upper)) {
                if (sb.length() > 1) {
                    sb.append(" & ");
                }
                sb.append(varExpression);
                sb.append(" <= ");
                sb.append(upper);
                ++num;
            }
        }
        if (data.hasNA()) {
            int n = na = (Boolean)this.selectedNA.getValue() != false ? 1 : -1;
        }
        if (num > 0 || na < 0) {
            if (na >= 0) {
                if (num > 1) {
                    sb.insert(0, '(');
                    sb.append(')');
                }
                if (num > 0) {
                    sb.append(" | ");
                }
                sb.append("is.na(").append(varExpression).append(')');
            } else {
                if (num > 0) {
                    sb.append(" & ");
                }
                sb.append("!is.na(").append(varExpression).append(')');
            }
        }
        sb.append(')');
        return sb.length() <= 2 ? "" : sb.toString();
    }

    public @Nullable Data getData() {
        return this.data;
    }

    public IObservableValue<Number> getSelectedLowerValue() {
        return this.selectedLowerValue;
    }

    public IObservableValue<Number> getSelectedUpperValue() {
        return this.selectedUpperValue;
    }

    public IObservableValue<Boolean> getSelectedNA() {
        return this.selectedNA;
    }

    public static abstract class Data {
        private final boolean hasNA;
        private final boolean hasMinMax;

        protected Data(boolean hasMinMax, boolean hasNA) {
            this.hasMinMax = hasMinMax;
            this.hasNA = hasNA;
        }

        public boolean hasMinMax() {
            return this.hasMinMax;
        }

        public abstract Number getMin();

        public abstract Number getMax();

        public abstract boolean isValidValue(Number var1);

        public abstract boolean isGreaterThanMin(Number var1);

        public abstract boolean isSmallerThanMax(Number var1);

        public boolean hasNA() {
            return this.hasNA;
        }
    }

    public static class IntData
    extends Data {
        private final int min;
        private final int max;

        private IntData(int min, int max, boolean hasNA) {
            super(true, hasNA);
            this.min = min;
            this.max = max;
        }

        private IntData(boolean hasNA) {
            super(false, hasNA);
            this.min = 0;
            this.max = 0;
        }

        public int getMinInt() {
            return this.min;
        }

        @Override
        public Integer getMin() {
            return this.min;
        }

        public int getMaxInt() {
            return this.max;
        }

        @Override
        public Integer getMax() {
            return this.max;
        }

        @Override
        public boolean isValidValue(Number value) {
            if (value instanceof Integer) {
                int v = value.intValue();
                return this.min <= v && v <= this.max;
            }
            return false;
        }

        @Override
        public boolean isGreaterThanMin(Number value) {
            return value != null && this.min < value.intValue();
        }

        @Override
        public boolean isSmallerThanMax(Number value) {
            return value != null && value.intValue() < this.max;
        }
    }

    public static class NumData
    extends Data {
        private final double min;
        private final double max;

        private NumData(double min, double max, boolean hasNA) {
            super(true, hasNA);
            this.min = min;
            this.max = max;
        }

        private NumData(boolean hasNA) {
            super(false, hasNA);
            this.min = 0.0;
            this.max = 0.0;
        }

        public double getMinDouble() {
            return this.min;
        }

        @Override
        public Double getMin() {
            return this.min;
        }

        public double getMaxDouble() {
            return this.max;
        }

        @Override
        public Double getMax() {
            return this.max;
        }

        @Override
        public boolean isValidValue(Number value) {
            if (value instanceof Double) {
                double v = value.doubleValue();
                return this.min <= v && v <= this.max;
            }
            return false;
        }

        @Override
        public boolean isGreaterThanMin(Number value) {
            return value != null && this.min < value.doubleValue();
        }

        @Override
        public boolean isSmallerThanMax(Number value) {
            return value != null && value.doubleValue() < this.max;
        }
    }
}

