/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.launching;

import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.LaunchShortcutUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class SubmitFileViaCommandLaunchShortcut
implements ILaunchShortcut {
    private final boolean fGotoConsole;
    private final String fFileCommandId;

    public SubmitFileViaCommandLaunchShortcut(String fileCommandId, boolean gotoConsole) {
        this.fFileCommandId = fileCommandId;
        this.fGotoConsole = gotoConsole;
    }

    public void launch(ISelection selection, String mode) {
        assert (mode.equals("run"));
        IWorkbenchPart workbenchPart = UIAccess.getActiveWorkbenchPart((boolean)false);
        IWorkbenchPartSite site = workbenchPart.getSite();
        if (site != null) {
            IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
            ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("fileCommandId", this.fFileCommandId);
            Command command = commandService.getCommand(!this.fGotoConsole ? "org.eclipse.statet.r.commands.SubmitFileToRViaCommand" : "org.eclipse.statet.r.commands.SubmitFileToRViaCommand_GotoConsole");
            ExecutionEvent executionEvent = new ExecutionEvent(command, parameters, null, (Object)handlerService.getCurrentState());
            if (!selection.equals(HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent))) {
                LaunchShortcutUtil.handleUnsupportedExecution(executionEvent);
                return;
            }
            try {
                command.executeWithChecks(executionEvent);
            }
            catch (ExecutionException e) {
                LaunchShortcutUtil.handleRLaunchException(e, RLaunchingMessages.RScriptLaunch_error_message, executionEvent);
            }
            catch (NotEnabledException | NotHandledException | NotDefinedException e) {
                LaunchShortcutUtil.handleUnsupportedExecution(executionEvent);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        assert (mode.equals("run"));
        IWorkbenchPart workbenchPart = UIAccess.getActiveWorkbenchPart((boolean)false);
        IWorkbenchPartSite site = workbenchPart.getSite();
        if (site != null) {
            IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
            ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("fileCommandId", this.fFileCommandId);
            Command command = commandService.getCommand(!this.fGotoConsole ? "org.eclipse.statet.r.commands.SubmitFileToRViaCommand" : "org.eclipse.statet.r.commands.SubmitFileToRViaCommand_GotoConsole");
            ExecutionEvent executionEvent = new ExecutionEvent(command, parameters, null, (Object)handlerService.getCurrentState());
            if (!editor.equals(HandlerUtil.getActivePart((ExecutionEvent)executionEvent))) {
                LaunchShortcutUtil.handleUnsupportedExecution(executionEvent);
                return;
            }
            try {
                command.executeWithChecks(executionEvent);
            }
            catch (ExecutionException e) {
                LaunchShortcutUtil.handleRLaunchException(e, RLaunchingMessages.RScriptLaunch_error_message, executionEvent);
            }
            catch (NotEnabledException | NotHandledException | NotDefinedException e) {
                LaunchShortcutUtil.handleUnsupportedExecution(executionEvent);
            }
        }
    }
}

