/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.r;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.ecommons.text.ui.presentation.AbstractRuleBasedScanner;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.rlang.RTokens;

@NonNullByDefault
public class ROperatorSpecialScanner
extends AbstractRuleBasedScanner {
    public ROperatorSpecialScanner(TextStyleManager<?> textStyles) {
        super(textStyles);
        this.initRules();
    }

    protected void createRules(List<IRule> rules) {
        TextStyleManager.TextStyleToken invalidOpToken = this.getToken("text_R_rUndefined");
        OpSpecialRule rule = new OpSpecialRule((IToken)this.getToken("text_R_rOtherOperators.Userdefined"), (IToken)invalidOpToken);
        rule.addSpecialOperators((ImList<String>)RTokens.FLOWCONTROL_SPECIAL_QUALIFIERS, (IToken)this.getToken("text_R_rOtherOperators.FlowControl"));
        rule.addSpecialOperators((ImList<String>)RTokens.COMMON_SPECIAL_QUALIFIERS, (IToken)this.getToken("text_R_rOtherOperators"));
        rules.add(rule);
    }

    private static class OpSpecialRule
    implements IRule {
        private final IToken defaultOpToken;
        private final IToken invalidOpToken;
        private final StringBuilder buffer;
        private final Map<String, IToken> specialIdentifiers;

        public OpSpecialRule(IToken userDefinedOpToken, IToken invalidOpToken) {
            this.defaultOpToken = userDefinedOpToken;
            this.invalidOpToken = invalidOpToken;
            this.buffer = new StringBuilder();
            this.specialIdentifiers = new HashMap<String, IToken>();
        }

        public void addSpecialOperators(ImList<String> identifiers, IToken token) {
            for (String identifier : identifiers) {
                this.specialIdentifiers.put(identifier, token);
            }
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int c = scanner.read();
            if (c == 37) {
                while (true) {
                    c = scanner.read();
                    switch (c) {
                        case 37: {
                            return this.succeed();
                        }
                        case -1: 
                        case 10: 
                        case 13: {
                            scanner.unread();
                            this.buffer.setLength(0);
                            return this.invalidOpToken;
                        }
                    }
                    this.buffer.append((char)c);
                }
            }
            scanner.unread();
            return Token.UNDEFINED;
        }

        private IToken succeed() {
            IToken token = this.specialIdentifiers.get(this.buffer.toString());
            this.buffer.setLength(0);
            return token != null ? token : this.defaultOpToken;
        }
    }
}

