/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rtm.base.ui.editors;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.rtm.base.ui.editors.Messages;
import org.eclipse.statet.internal.rtm.base.ui.editors.RCodeGenSourceFragment;
import org.eclipse.statet.rtm.base.core.AbstractRCodeGenerator;
import org.eclipse.statet.rtm.base.ui.IRtDescriptor;
import org.eclipse.statet.rtm.base.ui.RTaskSnippet;
import org.eclipse.statet.rtm.base.ui.editors.RTaskEditor;

public class RTaskGenManager
extends EContentAdapter {
    private final RTaskEditor editor;
    private final AbstractRCodeGenerator codeGenerator;
    private final RCodeGenSourceFragment codeFragment;
    private volatile boolean runnableScheduled;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            RTaskGenManager.this.runnableScheduled = false;
            RTaskGenManager.this.update();
        }
    };
    private RTaskSnippet currentTaskSnippet;

    public RTaskGenManager(RTaskEditor editor) {
        this.editor = editor;
        IRtDescriptor descriptor = this.editor.getModelDescriptor();
        this.codeGenerator = descriptor.createCodeGenerator();
        this.codeFragment = new RCodeGenSourceFragment(Messages.RTaskEditor_RCodePage_label, Messages.RTaskEditor_RCodePage_label + " - " + descriptor.getName());
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.runnableScheduled) {
            return;
        }
        UIAccess.getDisplay().asyncExec(this.runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        this.currentTaskSnippet = this.createRTaskSnippet();
        String code = this.currentTaskSnippet.getRCode();
        AbstractDocument document = this.codeFragment.getDocument();
        if (document instanceof ISynchronizable) {
            Object lockObject = ((ISynchronizable)document).getLockObject();
            if (lockObject == null) {
                lockObject = this.codeFragment;
            }
            Object object = lockObject;
            synchronized (object) {
                document.set(code);
            }
        } else {
            document.set(code);
        }
    }

    private RTaskSnippet createRTaskSnippet() {
        EObject root = (EObject)this.editor.getDataBinding().getRootObservable().getValue();
        this.codeGenerator.generate(root);
        IRtDescriptor descriptor = this.editor.getModelDescriptor();
        String label = descriptor.getName() + " (" + this.editor.getEditorInput().getName() + ")";
        return new RTaskSnippet(descriptor, label, this.codeGenerator.getRequiredPkgs(), this.codeGenerator.getRCode());
    }

    public RCodeGenSourceFragment getCodeFragment() {
        return this.codeFragment;
    }

    public RTaskSnippet getRTaskSnippet() {
        return this.currentTaskSnippet;
    }
}

